/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.cloudid;

import io.jenkins.plugins.akeyless.cloudid.CloudIdProvider;
import io.jenkins.plugins.akeyless.cloudid.Utils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class GcpCloudIdProvider
implements CloudIdProvider {
    private static final String METADATA_URL = "http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/identity?audience=akeyless.io&format=full";

    @Override
    public String getCloudId() throws Exception {
        String token = this.fetchIdentityToken();
        return Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchIdentityToken() throws Exception {
        HttpURLConnection conn = null;
        Object reader = null;
        try {
            URL url = new URL(METADATA_URL);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Metadata-Flavor", "Google");
            conn.setConnectTimeout(3000);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("Failed to retrieve identity token from GCP metadata server. Response code: " + responseCode);
            }
            String string = Utils.readDataFromStream(conn.getInputStream()).toString();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

