/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless;

import hudson.console.ConsoleLogFilter;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MaskSecretsLogsFilter
extends ConsoleLogFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String charsetName;
    private List<String> valuesToMask;

    public MaskSecretsLogsFilter(String charsetName, List<String> valuesToMask) {
        this.charsetName = charsetName;
        this.valuesToMask = valuesToMask;
    }

    public OutputStream decorateLogger(Run run, final OutputStream logger) throws IOException, InterruptedException {
        return new LineTransformationOutputStream(){
            Pattern p;

            protected void eol(byte[] b, int len) throws IOException {
                ArrayList<String> splitValuesToMask = new ArrayList<String>();
                for (String valueToMask : MaskSecretsLogsFilter.this.valuesToMask) {
                    ArrayList<String> splitValues = new ArrayList<String>(Arrays.asList(valueToMask.split("\n")));
                    splitValuesToMask.addAll(splitValues);
                }
                this.p = Pattern.compile(MaskSecretsLogsFilter.getPatternStringForSecrets(splitValuesToMask));
                if (StringUtils.isBlank((CharSequence)this.p.pattern())) {
                    logger.write(b, 0, len);
                    return;
                }
                Matcher m = this.p.matcher(new String(b, 0, len, MaskSecretsLogsFilter.this.charsetName));
                if (m.find()) {
                    logger.write(m.replaceAll("****").getBytes(MaskSecretsLogsFilter.this.charsetName));
                } else {
                    logger.write(b, 0, len);
                }
            }
        };
    }

    public static String getPatternStringForSecrets(Collection<String> secrets) {
        if (secrets == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        ArrayList<String> sortedByLength = new ArrayList<String>(secrets.size());
        for (String secret : secrets) {
            if (secret == null) continue;
            sortedByLength.add(secret);
        }
        sortedByLength.sort((o1, o2) -> o2.length() - o1.length());
        for (String secret : sortedByLength) {
            if (b.length() > 0) {
                b.append('|');
            }
            b.append(Pattern.quote(secret));
        }
        return b.toString();
    }
}

