/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import io.jenkins.plugins.akeyless.AkeylessAccessor;
import io.jenkins.plugins.akeyless.AkeylessPluginException;
import io.jenkins.plugins.akeyless.MaskSecretsLogsFilter;
import io.jenkins.plugins.akeyless.configuration.AkeylessConfigResolver;
import io.jenkins.plugins.akeyless.configuration.AkeylessConfiguration;
import io.jenkins.plugins.akeyless.model.AkeylessPKIIssuer;
import io.jenkins.plugins.akeyless.model.AkeylessSSHIssuer;
import io.jenkins.plugins.akeyless.model.AkeylessSecret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AkeylessBuildWrapper
extends SimpleBuildWrapper {
    protected transient PrintStream logger;
    private List<AkeylessSecret> akeylessSecrets;
    private transient AkeylessAccessor accessor;
    private AkeylessConfiguration configuration;
    private List<String> valuesToMask = new ArrayList<String>();
    private List<AkeylessPKIIssuer> akeylessPKIIssuers;
    private List<AkeylessSSHIssuer> akeylessSSHIssuers;

    @DataBoundConstructor
    public AkeylessBuildWrapper(@CheckForNull List<AkeylessSecret> akeylessSecrets, @CheckForNull List<AkeylessPKIIssuer> akeylessPKIIssuers, @CheckForNull List<AkeylessSSHIssuer> akeylessSSHIssuers) {
        this.akeylessSecrets = akeylessSecrets;
        this.akeylessPKIIssuers = akeylessPKIIssuers;
        this.akeylessSSHIssuers = akeylessSSHIssuers;
    }

    public List<AkeylessSecret> getAkeylessSecrets() {
        return this.akeylessSecrets;
    }

    public List<AkeylessPKIIssuer> getAkeylessPKIIssuers() {
        return this.akeylessPKIIssuers;
    }

    public List<AkeylessSSHIssuer> getAkeylessSSHIssuers() {
        return this.akeylessSSHIssuers;
    }

    @DataBoundSetter
    public void setConfiguration(AkeylessConfiguration configuration) {
        this.configuration = configuration;
    }

    public AkeylessConfiguration getConfiguration() {
        return this.configuration;
    }

    @VisibleForTesting
    public void setAkeylessAccessor(AkeylessAccessor accessor) {
        this.accessor = accessor;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        this.logger = listener.getLogger();
        this.buildConfiguration(build);
        this.retrieveSecretsAndSetToEnvironments(context, build, initialEnvironment);
    }

    private void retrieveSecretsAndSetToEnvironments(SimpleBuildWrapper.Context context, Run<?, ?> build, EnvVars envVars) {
        Map<String, String> overrides = AkeylessAccessor.retrieveSecrets(build, this.logger, envVars, this.accessor, this.getConfiguration(), this.getAkeylessSecrets(), this.getAkeylessPKIIssuers(), this.getAkeylessSSHIssuers());
        for (Map.Entry<String, String> secret : overrides.entrySet()) {
            this.valuesToMask.add(secret.getValue());
            context.env(secret.getKey(), secret.getValue());
        }
    }

    private void buildConfiguration(Run<?, ?> build) {
        for (AkeylessConfigResolver resolver : ExtensionList.lookup(AkeylessConfigResolver.class)) {
            if (this.configuration != null) {
                this.configuration = this.configuration.mergeWithParent(resolver.forJob((Item)build.getParent()));
                continue;
            }
            this.configuration = resolver.forJob((Item)build.getParent());
        }
        if (this.configuration == null) {
            throw new AkeylessPluginException("No configuration found - please configure the AkeylessPlugin.");
        }
    }

    public ConsoleLogFilter createLoggerDecorator(@NonNull Run<?, ?> build) {
        return new MaskSecretsLogsFilter(build.getCharset().name(), this.valuesToMask);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(AkeylessBuildWrapper.class);
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Akeyless Plugin";
        }
    }
}

