/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="updateTokenizer is a command that updates a tokenizer item")
public class UpdateTokenizer {
    public static final String SERIALIZED_NAME_ADD_TAG = "add-tag";
    @SerializedName(value="add-tag")
    private List<String> addTag = null;
    public static final String SERIALIZED_NAME_ALPHABET = "alphabet";
    @SerializedName(value="alphabet")
    private String alphabet;
    public static final String SERIALIZED_NAME_DECODING_TEMPLATE = "decoding-template";
    @SerializedName(value="decoding-template")
    private String decodingTemplate;
    public static final String SERIALIZED_NAME_DELETE_PROTECTION = "delete_protection";
    @SerializedName(value="delete_protection")
    private String deleteProtection;
    public static final String SERIALIZED_NAME_ENCODING_TEMPLATE = "encoding-template";
    @SerializedName(value="encoding-template")
    private String encodingTemplate;
    public static final String SERIALIZED_NAME_ENCRYPTION_KEY_NAME = "encryption-key-name";
    @SerializedName(value="encryption-key-name")
    private String encryptionKeyName;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NEW_METADATA = "new-metadata";
    @SerializedName(value="new-metadata")
    private String newMetadata = "default_metadata";
    public static final String SERIALIZED_NAME_NEW_NAME = "new-name";
    @SerializedName(value="new-name")
    private String newName;
    public static final String SERIALIZED_NAME_PATTERN = "pattern";
    @SerializedName(value="pattern")
    private String pattern;
    public static final String SERIALIZED_NAME_RM_TAG = "rm-tag";
    @SerializedName(value="rm-tag")
    private List<String> rmTag = null;
    public static final String SERIALIZED_NAME_TEMPLATE_TYPE = "template-type";
    @SerializedName(value="template-type")
    private String templateType;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_TOKENIZER_TYPE = "tokenizer-type";
    @SerializedName(value="tokenizer-type")
    private String tokenizerType;
    public static final String SERIALIZED_NAME_TWEAK_TYPE = "tweak-type";
    @SerializedName(value="tweak-type")
    private String tweakType;
    public static final String SERIALIZED_NAME_UID_TOKEN = "uid-token";
    @SerializedName(value="uid-token")
    private String uidToken;

    public UpdateTokenizer addTag(List<String> addTag) {
        this.addTag = addTag;
        return this;
    }

    public UpdateTokenizer addAddTagItem(String addTagItem) {
        if (this.addTag == null) {
            this.addTag = new ArrayList<String>();
        }
        this.addTag.add(addTagItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of the new tags that will be attached to this item")
    public List<String> getAddTag() {
        return this.addTag;
    }

    public void setAddTag(List<String> addTag) {
        this.addTag = addTag;
    }

    public UpdateTokenizer alphabet(String alphabet) {
        this.alphabet = alphabet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Alphabet to use in regexp vaultless tokenization")
    public String getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(String alphabet) {
        this.alphabet = alphabet;
    }

    public UpdateTokenizer decodingTemplate(String decodingTemplate) {
        this.decodingTemplate = decodingTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Decoding output template to use in regexp vaultless tokenization")
    public String getDecodingTemplate() {
        return this.decodingTemplate;
    }

    public void setDecodingTemplate(String decodingTemplate) {
        this.decodingTemplate = decodingTemplate;
    }

    public UpdateTokenizer deleteProtection(String deleteProtection) {
        this.deleteProtection = deleteProtection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getDeleteProtection() {
        return this.deleteProtection;
    }

    public void setDeleteProtection(String deleteProtection) {
        this.deleteProtection = deleteProtection;
    }

    public UpdateTokenizer encodingTemplate(String encodingTemplate) {
        this.encodingTemplate = encodingTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Encoding output template to use in regexp vaultless tokenization")
    public String getEncodingTemplate() {
        return this.encodingTemplate;
    }

    public void setEncodingTemplate(String encodingTemplate) {
        this.encodingTemplate = encodingTemplate;
    }

    public UpdateTokenizer encryptionKeyName(String encryptionKeyName) {
        this.encryptionKeyName = encryptionKeyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AES key name to use in vaultless tokenization")
    public String getEncryptionKeyName() {
        return this.encryptionKeyName;
    }

    public void setEncryptionKeyName(String encryptionKeyName) {
        this.encryptionKeyName = encryptionKeyName;
    }

    public UpdateTokenizer name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Current item name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateTokenizer newMetadata(String newMetadata) {
        this.newMetadata = newMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="New item metadata")
    public String getNewMetadata() {
        return this.newMetadata;
    }

    public void setNewMetadata(String newMetadata) {
        this.newMetadata = newMetadata;
    }

    public UpdateTokenizer newName(String newName) {
        this.newName = newName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="New item name")
    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public UpdateTokenizer pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pattern to use in regexp vaultless tokenization")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public UpdateTokenizer rmTag(List<String> rmTag) {
        this.rmTag = rmTag;
        return this;
    }

    public UpdateTokenizer addRmTagItem(String rmTagItem) {
        if (this.rmTag == null) {
            this.rmTag = new ArrayList<String>();
        }
        this.rmTag.add(rmTagItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of the existent tags that will be removed from this item")
    public List<String> getRmTag() {
        return this.rmTag;
    }

    public void setRmTag(List<String> rmTag) {
        this.rmTag = rmTag;
    }

    public UpdateTokenizer templateType(String templateType) {
        this.templateType = templateType;
        return this;
    }

    @ApiModelProperty(required=true, value="Which template type this tokenizer is used for [SSN,CreditCard,USPhoneNumber,Email,Regexp]")
    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public UpdateTokenizer token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authentication token (see `/auth` and `/configure`)")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public UpdateTokenizer tokenizerType(String tokenizerType) {
        this.tokenizerType = tokenizerType;
        return this;
    }

    @ApiModelProperty(required=true, value="Tokenizer type")
    public String getTokenizerType() {
        return this.tokenizerType;
    }

    public void setTokenizerType(String tokenizerType) {
        this.tokenizerType = tokenizerType;
    }

    public UpdateTokenizer tweakType(String tweakType) {
        this.tweakType = tweakType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tweak type to use in vaultless tokenization [Supplied, Generated, Internal, Masking]")
    public String getTweakType() {
        return this.tweakType;
    }

    public void setTweakType(String tweakType) {
        this.tweakType = tweakType;
    }

    public UpdateTokenizer uidToken(String uidToken) {
        this.uidToken = uidToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The universal identity token, Required only for universal_identity authentication")
    public String getUidToken() {
        return this.uidToken;
    }

    public void setUidToken(String uidToken) {
        this.uidToken = uidToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTokenizer updateTokenizer = (UpdateTokenizer)o;
        return Objects.equals(this.addTag, updateTokenizer.addTag) && Objects.equals(this.alphabet, updateTokenizer.alphabet) && Objects.equals(this.decodingTemplate, updateTokenizer.decodingTemplate) && Objects.equals(this.deleteProtection, updateTokenizer.deleteProtection) && Objects.equals(this.encodingTemplate, updateTokenizer.encodingTemplate) && Objects.equals(this.encryptionKeyName, updateTokenizer.encryptionKeyName) && Objects.equals(this.name, updateTokenizer.name) && Objects.equals(this.newMetadata, updateTokenizer.newMetadata) && Objects.equals(this.newName, updateTokenizer.newName) && Objects.equals(this.pattern, updateTokenizer.pattern) && Objects.equals(this.rmTag, updateTokenizer.rmTag) && Objects.equals(this.templateType, updateTokenizer.templateType) && Objects.equals(this.token, updateTokenizer.token) && Objects.equals(this.tokenizerType, updateTokenizer.tokenizerType) && Objects.equals(this.tweakType, updateTokenizer.tweakType) && Objects.equals(this.uidToken, updateTokenizer.uidToken);
    }

    public int hashCode() {
        return Objects.hash(this.addTag, this.alphabet, this.decodingTemplate, this.deleteProtection, this.encodingTemplate, this.encryptionKeyName, this.name, this.newMetadata, this.newName, this.pattern, this.rmTag, this.templateType, this.token, this.tokenizerType, this.tweakType, this.uidToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTokenizer {\n");
        sb.append("    addTag: ").append(this.toIndentedString(this.addTag)).append("\n");
        sb.append("    alphabet: ").append(this.toIndentedString(this.alphabet)).append("\n");
        sb.append("    decodingTemplate: ").append(this.toIndentedString(this.decodingTemplate)).append("\n");
        sb.append("    deleteProtection: ").append(this.toIndentedString(this.deleteProtection)).append("\n");
        sb.append("    encodingTemplate: ").append(this.toIndentedString(this.encodingTemplate)).append("\n");
        sb.append("    encryptionKeyName: ").append(this.toIndentedString(this.encryptionKeyName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    newMetadata: ").append(this.toIndentedString(this.newMetadata)).append("\n");
        sb.append("    newName: ").append(this.toIndentedString(this.newName)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    rmTag: ").append(this.toIndentedString(this.rmTag)).append("\n");
        sb.append("    templateType: ").append(this.toIndentedString(this.templateType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenizerType: ").append(this.toIndentedString(this.tokenizerType)).append("\n");
        sb.append("    tweakType: ").append(this.toIndentedString(this.tweakType)).append("\n");
        sb.append("    uidToken: ").append(this.toIndentedString(this.uidToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

