/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.akeyless.client.JSON;
import io.akeyless.client.model.SAMLAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class SAMLAccessRules {
    public static final String SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS = "allowed_redirect_URIs";
    @SerializedName(value="allowed_redirect_URIs")
    @Nullable
    private List<String> allowedRedirectURIs = new ArrayList<String>();
    public static final String SERIALIZED_NAME_BOUND_ATTRIBUTES = "bound_attributes";
    @SerializedName(value="bound_attributes")
    @Nullable
    private List<SAMLAttribute> boundAttributes = new ArrayList<SAMLAttribute>();
    public static final String SERIALIZED_NAME_IDP_METADATA_URL = "idp_metadata_url";
    @SerializedName(value="idp_metadata_url")
    @Nullable
    private String idpMetadataUrl;
    public static final String SERIALIZED_NAME_IDP_METADATA_XML = "idp_metadata_xml";
    @SerializedName(value="idp_metadata_xml")
    @Nullable
    private String idpMetadataXml;
    public static final String SERIALIZED_NAME_UNIQUE_IDENTIFIER = "unique_identifier";
    @SerializedName(value="unique_identifier")
    @Nullable
    private String uniqueIdentifier;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SAMLAccessRules allowedRedirectURIs(@Nullable List<String> allowedRedirectURIs) {
        this.allowedRedirectURIs = allowedRedirectURIs;
        return this;
    }

    public SAMLAccessRules addAllowedRedirectURIsItem(String allowedRedirectURIsItem) {
        if (this.allowedRedirectURIs == null) {
            this.allowedRedirectURIs = new ArrayList<String>();
        }
        this.allowedRedirectURIs.add(allowedRedirectURIsItem);
        return this;
    }

    @Nullable
    public List<String> getAllowedRedirectURIs() {
        return this.allowedRedirectURIs;
    }

    public void setAllowedRedirectURIs(@Nullable List<String> allowedRedirectURIs) {
        this.allowedRedirectURIs = allowedRedirectURIs;
    }

    public SAMLAccessRules boundAttributes(@Nullable List<SAMLAttribute> boundAttributes) {
        this.boundAttributes = boundAttributes;
        return this;
    }

    public SAMLAccessRules addBoundAttributesItem(SAMLAttribute boundAttributesItem) {
        if (this.boundAttributes == null) {
            this.boundAttributes = new ArrayList<SAMLAttribute>();
        }
        this.boundAttributes.add(boundAttributesItem);
        return this;
    }

    @Nullable
    public List<SAMLAttribute> getBoundAttributes() {
        return this.boundAttributes;
    }

    public void setBoundAttributes(@Nullable List<SAMLAttribute> boundAttributes) {
        this.boundAttributes = boundAttributes;
    }

    public SAMLAccessRules idpMetadataUrl(@Nullable String idpMetadataUrl) {
        this.idpMetadataUrl = idpMetadataUrl;
        return this;
    }

    @Nullable
    public String getIdpMetadataUrl() {
        return this.idpMetadataUrl;
    }

    public void setIdpMetadataUrl(@Nullable String idpMetadataUrl) {
        this.idpMetadataUrl = idpMetadataUrl;
    }

    public SAMLAccessRules idpMetadataXml(@Nullable String idpMetadataXml) {
        this.idpMetadataXml = idpMetadataXml;
        return this;
    }

    @Nullable
    public String getIdpMetadataXml() {
        return this.idpMetadataXml;
    }

    public void setIdpMetadataXml(@Nullable String idpMetadataXml) {
        this.idpMetadataXml = idpMetadataXml;
    }

    public SAMLAccessRules uniqueIdentifier(@Nullable String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
        return this;
    }

    @Nullable
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setUniqueIdentifier(@Nullable String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLAccessRules saMLAccessRules = (SAMLAccessRules)o;
        return Objects.equals(this.allowedRedirectURIs, saMLAccessRules.allowedRedirectURIs) && Objects.equals(this.boundAttributes, saMLAccessRules.boundAttributes) && Objects.equals(this.idpMetadataUrl, saMLAccessRules.idpMetadataUrl) && Objects.equals(this.idpMetadataXml, saMLAccessRules.idpMetadataXml) && Objects.equals(this.uniqueIdentifier, saMLAccessRules.uniqueIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.allowedRedirectURIs, this.boundAttributes, this.idpMetadataUrl, this.idpMetadataXml, this.uniqueIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLAccessRules {\n");
        sb.append("    allowedRedirectURIs: ").append(this.toIndentedString(this.allowedRedirectURIs)).append("\n");
        sb.append("    boundAttributes: ").append(this.toIndentedString(this.boundAttributes)).append("\n");
        sb.append("    idpMetadataUrl: ").append(this.toIndentedString(this.idpMetadataUrl)).append("\n");
        sb.append("    idpMetadataXml: ").append(this.toIndentedString(this.idpMetadataXml)).append("\n");
        sb.append("    uniqueIdentifier: ").append(this.toIndentedString(this.uniqueIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayboundAttributes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SAMLAccessRules is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SAMLAccessRules` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_redirect_URIs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BOUND_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_BOUND_ATTRIBUTES).isJsonNull() && (jsonArrayboundAttributes = jsonObj.getAsJsonArray(SERIALIZED_NAME_BOUND_ATTRIBUTES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BOUND_ATTRIBUTES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `bound_attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BOUND_ATTRIBUTES).toString()));
            }
            for (int i = 0; i < jsonArrayboundAttributes.size(); ++i) {
                SAMLAttribute.validateJsonElement(jsonArrayboundAttributes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_IDP_METADATA_URL) != null && !jsonObj.get(SERIALIZED_NAME_IDP_METADATA_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IDP_METADATA_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `idp_metadata_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IDP_METADATA_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDP_METADATA_XML) != null && !jsonObj.get(SERIALIZED_NAME_IDP_METADATA_XML).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IDP_METADATA_XML).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `idp_metadata_xml` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IDP_METADATA_XML).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unique_identifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).toString()));
        }
    }

    public static SAMLAccessRules fromJson(String jsonString) throws IOException {
        return (SAMLAccessRules)JSON.getGson().fromJson(jsonString, SAMLAccessRules.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS);
        openapiFields.add(SERIALIZED_NAME_BOUND_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_IDP_METADATA_URL);
        openapiFields.add(SERIALIZED_NAME_IDP_METADATA_XML);
        openapiFields.add(SERIALIZED_NAME_UNIQUE_IDENTIFIER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SAMLAccessRules.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SAMLAccessRules.class));
            return new TypeAdapter<SAMLAccessRules>(){

                public void write(JsonWriter out, SAMLAccessRules value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SAMLAccessRules read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SAMLAccessRules.validateJsonElement(jsonElement);
                    return (SAMLAccessRules)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

