/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.akeyless.client.JSON;
import io.akeyless.client.model.OIDCCustomClaim;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class OIDCAccessRules {
    public static final String SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS = "allowed_redirect_URIs";
    @SerializedName(value="allowed_redirect_URIs")
    @Nullable
    private List<String> allowedRedirectURIs = new ArrayList<String>();
    public static final String SERIALIZED_NAME_AUDIENCE = "audience";
    @SerializedName(value="audience")
    @Nullable
    private String audience;
    public static final String SERIALIZED_NAME_BOUND_CLAIMS = "bound_claims";
    @SerializedName(value="bound_claims")
    @Nullable
    private List<OIDCCustomClaim> boundClaims = new ArrayList<OIDCCustomClaim>();
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    @Nullable
    private String clientId;
    public static final String SERIALIZED_NAME_CLIENT_SECRET = "client_secret";
    @SerializedName(value="client_secret")
    @Nullable
    private String clientSecret;
    public static final String SERIALIZED_NAME_IS_INTERNAL = "is_internal";
    @SerializedName(value="is_internal")
    @Nullable
    private Boolean isInternal;
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    @Nullable
    private String issuer;
    public static final String SERIALIZED_NAME_REQUIRED_SCOPES = "required_scopes";
    @SerializedName(value="required_scopes")
    @Nullable
    private List<String> requiredScopes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REQUIRED_SCOPES_PREFIX = "required_scopes_prefix";
    @SerializedName(value="required_scopes_prefix")
    @Nullable
    private String requiredScopesPrefix;
    public static final String SERIALIZED_NAME_UNIQUE_IDENTIFIER = "unique_identifier";
    @SerializedName(value="unique_identifier")
    @Nullable
    private String uniqueIdentifier;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OIDCAccessRules allowedRedirectURIs(@Nullable List<String> allowedRedirectURIs) {
        this.allowedRedirectURIs = allowedRedirectURIs;
        return this;
    }

    public OIDCAccessRules addAllowedRedirectURIsItem(String allowedRedirectURIsItem) {
        if (this.allowedRedirectURIs == null) {
            this.allowedRedirectURIs = new ArrayList<String>();
        }
        this.allowedRedirectURIs.add(allowedRedirectURIsItem);
        return this;
    }

    @Nullable
    public List<String> getAllowedRedirectURIs() {
        return this.allowedRedirectURIs;
    }

    public void setAllowedRedirectURIs(@Nullable List<String> allowedRedirectURIs) {
        this.allowedRedirectURIs = allowedRedirectURIs;
    }

    public OIDCAccessRules audience(@Nullable String audience) {
        this.audience = audience;
        return this;
    }

    @Nullable
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(@Nullable String audience) {
        this.audience = audience;
    }

    public OIDCAccessRules boundClaims(@Nullable List<OIDCCustomClaim> boundClaims) {
        this.boundClaims = boundClaims;
        return this;
    }

    public OIDCAccessRules addBoundClaimsItem(OIDCCustomClaim boundClaimsItem) {
        if (this.boundClaims == null) {
            this.boundClaims = new ArrayList<OIDCCustomClaim>();
        }
        this.boundClaims.add(boundClaimsItem);
        return this;
    }

    @Nullable
    public List<OIDCCustomClaim> getBoundClaims() {
        return this.boundClaims;
    }

    public void setBoundClaims(@Nullable List<OIDCCustomClaim> boundClaims) {
        this.boundClaims = boundClaims;
    }

    public OIDCAccessRules clientId(@Nullable String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    public OIDCAccessRules clientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OIDCAccessRules isInternal(@Nullable Boolean isInternal) {
        this.isInternal = isInternal;
        return this;
    }

    @Nullable
    public Boolean getIsInternal() {
        return this.isInternal;
    }

    public void setIsInternal(@Nullable Boolean isInternal) {
        this.isInternal = isInternal;
    }

    public OIDCAccessRules issuer(@Nullable String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable String issuer) {
        this.issuer = issuer;
    }

    public OIDCAccessRules requiredScopes(@Nullable List<String> requiredScopes) {
        this.requiredScopes = requiredScopes;
        return this;
    }

    public OIDCAccessRules addRequiredScopesItem(String requiredScopesItem) {
        if (this.requiredScopes == null) {
            this.requiredScopes = new ArrayList<String>();
        }
        this.requiredScopes.add(requiredScopesItem);
        return this;
    }

    @Nullable
    public List<String> getRequiredScopes() {
        return this.requiredScopes;
    }

    public void setRequiredScopes(@Nullable List<String> requiredScopes) {
        this.requiredScopes = requiredScopes;
    }

    public OIDCAccessRules requiredScopesPrefix(@Nullable String requiredScopesPrefix) {
        this.requiredScopesPrefix = requiredScopesPrefix;
        return this;
    }

    @Nullable
    public String getRequiredScopesPrefix() {
        return this.requiredScopesPrefix;
    }

    public void setRequiredScopesPrefix(@Nullable String requiredScopesPrefix) {
        this.requiredScopesPrefix = requiredScopesPrefix;
    }

    public OIDCAccessRules uniqueIdentifier(@Nullable String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
        return this;
    }

    @Nullable
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setUniqueIdentifier(@Nullable String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIDCAccessRules oiDCAccessRules = (OIDCAccessRules)o;
        return Objects.equals(this.allowedRedirectURIs, oiDCAccessRules.allowedRedirectURIs) && Objects.equals(this.audience, oiDCAccessRules.audience) && Objects.equals(this.boundClaims, oiDCAccessRules.boundClaims) && Objects.equals(this.clientId, oiDCAccessRules.clientId) && Objects.equals(this.clientSecret, oiDCAccessRules.clientSecret) && Objects.equals(this.isInternal, oiDCAccessRules.isInternal) && Objects.equals(this.issuer, oiDCAccessRules.issuer) && Objects.equals(this.requiredScopes, oiDCAccessRules.requiredScopes) && Objects.equals(this.requiredScopesPrefix, oiDCAccessRules.requiredScopesPrefix) && Objects.equals(this.uniqueIdentifier, oiDCAccessRules.uniqueIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.allowedRedirectURIs, this.audience, this.boundClaims, this.clientId, this.clientSecret, this.isInternal, this.issuer, this.requiredScopes, this.requiredScopesPrefix, this.uniqueIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OIDCAccessRules {\n");
        sb.append("    allowedRedirectURIs: ").append(this.toIndentedString(this.allowedRedirectURIs)).append("\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    boundClaims: ").append(this.toIndentedString(this.boundClaims)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    isInternal: ").append(this.toIndentedString(this.isInternal)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    requiredScopes: ").append(this.toIndentedString(this.requiredScopes)).append("\n");
        sb.append("    requiredScopesPrefix: ").append(this.toIndentedString(this.requiredScopesPrefix)).append("\n");
        sb.append("    uniqueIdentifier: ").append(this.toIndentedString(this.uniqueIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayboundClaims;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OIDCAccessRules is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OIDCAccessRules` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_redirect_URIs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUDIENCE) != null && !jsonObj.get(SERIALIZED_NAME_AUDIENCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUDIENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `audience` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUDIENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS) != null && !jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS).isJsonNull() && (jsonArrayboundClaims = jsonObj.getAsJsonArray(SERIALIZED_NAME_BOUND_CLAIMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `bound_claims` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS).toString()));
            }
            for (int i = 0; i < jsonArrayboundClaims.size(); ++i) {
                OIDCCustomClaim.validateJsonElement(jsonArrayboundClaims.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ISSUER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuer` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `required_scopes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES_PREFIX) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES_PREFIX).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES_PREFIX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `required_scopes_prefix` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRED_SCOPES_PREFIX).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unique_identifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).toString()));
        }
    }

    public static OIDCAccessRules fromJson(String jsonString) throws IOException {
        return (OIDCAccessRules)JSON.getGson().fromJson(jsonString, OIDCAccessRules.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED_REDIRECT_U_R_IS);
        openapiFields.add(SERIALIZED_NAME_AUDIENCE);
        openapiFields.add(SERIALIZED_NAME_BOUND_CLAIMS);
        openapiFields.add(SERIALIZED_NAME_CLIENT_ID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_SECRET);
        openapiFields.add(SERIALIZED_NAME_IS_INTERNAL);
        openapiFields.add(SERIALIZED_NAME_ISSUER);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_SCOPES);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_SCOPES_PREFIX);
        openapiFields.add(SERIALIZED_NAME_UNIQUE_IDENTIFIER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OIDCAccessRules.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OIDCAccessRules.class));
            return new TypeAdapter<OIDCAccessRules>(){

                public void write(JsonWriter out, OIDCAccessRules value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OIDCAccessRules read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OIDCAccessRules.validateJsonElement(jsonElement);
                    return (OIDCAccessRules)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

