/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.akeyless.client.JSON;
import io.akeyless.client.model.OAuth2CustomClaim;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class OAuth2AccessRules {
    public static final String SERIALIZED_NAME_AUDIENCE = "audience";
    @SerializedName(value="audience")
    @Nullable
    private String audience;
    public static final String SERIALIZED_NAME_AUTHORIZED_GW_CLUSTER_NAME = "authorized_gw_cluster_name";
    @SerializedName(value="authorized_gw_cluster_name")
    @Nullable
    private String authorizedGwClusterName;
    public static final String SERIALIZED_NAME_BOUND_CLAIMS = "bound_claims";
    @SerializedName(value="bound_claims")
    @Nullable
    private List<OAuth2CustomClaim> boundClaims = new ArrayList<OAuth2CustomClaim>();
    public static final String SERIALIZED_NAME_BOUND_CLIENTS_ID = "bound_clients_id";
    @SerializedName(value="bound_clients_id")
    @Nullable
    private List<String> boundClientsId = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CERTIFICATE = "certificate";
    @SerializedName(value="certificate")
    @Nullable
    private String certificate;
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    @Nullable
    private String issuer;
    public static final String SERIALIZED_NAME_JWKS_JSON_DATA = "jwks_json_data";
    @SerializedName(value="jwks_json_data")
    @Nullable
    private String jwksJsonData;
    public static final String SERIALIZED_NAME_JWKS_URI = "jwks_uri";
    @SerializedName(value="jwks_uri")
    @Nullable
    private String jwksUri;
    public static final String SERIALIZED_NAME_UNIQUE_IDENTIFIER = "unique_identifier";
    @SerializedName(value="unique_identifier")
    @Nullable
    private String uniqueIdentifier;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OAuth2AccessRules audience(@Nullable String audience) {
        this.audience = audience;
        return this;
    }

    @Nullable
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(@Nullable String audience) {
        this.audience = audience;
    }

    public OAuth2AccessRules authorizedGwClusterName(@Nullable String authorizedGwClusterName) {
        this.authorizedGwClusterName = authorizedGwClusterName;
        return this;
    }

    @Nullable
    public String getAuthorizedGwClusterName() {
        return this.authorizedGwClusterName;
    }

    public void setAuthorizedGwClusterName(@Nullable String authorizedGwClusterName) {
        this.authorizedGwClusterName = authorizedGwClusterName;
    }

    public OAuth2AccessRules boundClaims(@Nullable List<OAuth2CustomClaim> boundClaims) {
        this.boundClaims = boundClaims;
        return this;
    }

    public OAuth2AccessRules addBoundClaimsItem(OAuth2CustomClaim boundClaimsItem) {
        if (this.boundClaims == null) {
            this.boundClaims = new ArrayList<OAuth2CustomClaim>();
        }
        this.boundClaims.add(boundClaimsItem);
        return this;
    }

    @Nullable
    public List<OAuth2CustomClaim> getBoundClaims() {
        return this.boundClaims;
    }

    public void setBoundClaims(@Nullable List<OAuth2CustomClaim> boundClaims) {
        this.boundClaims = boundClaims;
    }

    public OAuth2AccessRules boundClientsId(@Nullable List<String> boundClientsId) {
        this.boundClientsId = boundClientsId;
        return this;
    }

    public OAuth2AccessRules addBoundClientsIdItem(String boundClientsIdItem) {
        if (this.boundClientsId == null) {
            this.boundClientsId = new ArrayList<String>();
        }
        this.boundClientsId.add(boundClientsIdItem);
        return this;
    }

    @Nullable
    public List<String> getBoundClientsId() {
        return this.boundClientsId;
    }

    public void setBoundClientsId(@Nullable List<String> boundClientsId) {
        this.boundClientsId = boundClientsId;
    }

    public OAuth2AccessRules certificate(@Nullable String certificate) {
        this.certificate = certificate;
        return this;
    }

    @Nullable
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(@Nullable String certificate) {
        this.certificate = certificate;
    }

    public OAuth2AccessRules issuer(@Nullable String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable String issuer) {
        this.issuer = issuer;
    }

    public OAuth2AccessRules jwksJsonData(@Nullable String jwksJsonData) {
        this.jwksJsonData = jwksJsonData;
        return this;
    }

    @Nullable
    public String getJwksJsonData() {
        return this.jwksJsonData;
    }

    public void setJwksJsonData(@Nullable String jwksJsonData) {
        this.jwksJsonData = jwksJsonData;
    }

    public OAuth2AccessRules jwksUri(@Nullable String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(@Nullable String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OAuth2AccessRules uniqueIdentifier(@Nullable String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
        return this;
    }

    @Nullable
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setUniqueIdentifier(@Nullable String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2AccessRules oauth2AccessRules = (OAuth2AccessRules)o;
        return Objects.equals(this.audience, oauth2AccessRules.audience) && Objects.equals(this.authorizedGwClusterName, oauth2AccessRules.authorizedGwClusterName) && Objects.equals(this.boundClaims, oauth2AccessRules.boundClaims) && Objects.equals(this.boundClientsId, oauth2AccessRules.boundClientsId) && Objects.equals(this.certificate, oauth2AccessRules.certificate) && Objects.equals(this.issuer, oauth2AccessRules.issuer) && Objects.equals(this.jwksJsonData, oauth2AccessRules.jwksJsonData) && Objects.equals(this.jwksUri, oauth2AccessRules.jwksUri) && Objects.equals(this.uniqueIdentifier, oauth2AccessRules.uniqueIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.authorizedGwClusterName, this.boundClaims, this.boundClientsId, this.certificate, this.issuer, this.jwksJsonData, this.jwksUri, this.uniqueIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2AccessRules {\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    authorizedGwClusterName: ").append(this.toIndentedString(this.authorizedGwClusterName)).append("\n");
        sb.append("    boundClaims: ").append(this.toIndentedString(this.boundClaims)).append("\n");
        sb.append("    boundClientsId: ").append(this.toIndentedString(this.boundClientsId)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksJsonData: ").append(this.toIndentedString(this.jwksJsonData)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    uniqueIdentifier: ").append(this.toIndentedString(this.uniqueIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayboundClaims;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OAuth2AccessRules is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OAuth2AccessRules` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_AUDIENCE) != null && !jsonObj.get(SERIALIZED_NAME_AUDIENCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUDIENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `audience` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUDIENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHORIZED_GW_CLUSTER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_AUTHORIZED_GW_CLUSTER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUTHORIZED_GW_CLUSTER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `authorized_gw_cluster_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHORIZED_GW_CLUSTER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS) != null && !jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS).isJsonNull() && (jsonArrayboundClaims = jsonObj.getAsJsonArray(SERIALIZED_NAME_BOUND_CLAIMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `bound_claims` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BOUND_CLAIMS).toString()));
            }
            for (int i = 0; i < jsonArrayboundClaims.size(); ++i) {
                OAuth2CustomClaim.validateJsonElement(jsonArrayboundClaims.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BOUND_CLIENTS_ID) != null && !jsonObj.get(SERIALIZED_NAME_BOUND_CLIENTS_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BOUND_CLIENTS_ID).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bound_clients_id` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BOUND_CLIENTS_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CERTIFICATE) != null && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `certificate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CERTIFICATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ISSUER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuer` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_JWKS_JSON_DATA) != null && !jsonObj.get(SERIALIZED_NAME_JWKS_JSON_DATA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_JWKS_JSON_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `jwks_json_data` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JWKS_JSON_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_JWKS_URI) != null && !jsonObj.get(SERIALIZED_NAME_JWKS_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_JWKS_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `jwks_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JWKS_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unique_identifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIQUE_IDENTIFIER).toString()));
        }
    }

    public static OAuth2AccessRules fromJson(String jsonString) throws IOException {
        return (OAuth2AccessRules)JSON.getGson().fromJson(jsonString, OAuth2AccessRules.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUDIENCE);
        openapiFields.add(SERIALIZED_NAME_AUTHORIZED_GW_CLUSTER_NAME);
        openapiFields.add(SERIALIZED_NAME_BOUND_CLAIMS);
        openapiFields.add(SERIALIZED_NAME_BOUND_CLIENTS_ID);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ISSUER);
        openapiFields.add(SERIALIZED_NAME_JWKS_JSON_DATA);
        openapiFields.add(SERIALIZED_NAME_JWKS_URI);
        openapiFields.add(SERIALIZED_NAME_UNIQUE_IDENTIFIER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OAuth2AccessRules.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OAuth2AccessRules.class));
            return new TypeAdapter<OAuth2AccessRules>(){

                public void write(JsonWriter out, OAuth2AccessRules value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OAuth2AccessRules read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OAuth2AccessRules.validateJsonElement(jsonElement);
                    return (OAuth2AccessRules)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

