/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.akeyless.client.JSON;
import io.akeyless.client.model.KubeconfigNamedCluster;
import io.akeyless.client.model.KubeconfigNamedContext;
import io.akeyless.client.model.KubeconfigUser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class KubeConfigValue {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    @Nullable
    private String apiVersion;
    public static final String SERIALIZED_NAME_CLUSTERS = "clusters";
    @SerializedName(value="clusters")
    @Nullable
    private List<KubeconfigNamedCluster> clusters = new ArrayList<KubeconfigNamedCluster>();
    public static final String SERIALIZED_NAME_CONTEXTS = "contexts";
    @SerializedName(value="contexts")
    @Nullable
    private List<KubeconfigNamedContext> contexts = new ArrayList<KubeconfigNamedContext>();
    public static final String SERIALIZED_NAME_CURRENT_CONTEXT = "current-context";
    @SerializedName(value="current-context")
    @Nullable
    private String currentContext;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nullable
    private String kind;
    public static final String SERIALIZED_NAME_USERS = "users";
    @SerializedName(value="users")
    @Nullable
    private List<KubeconfigUser> users = new ArrayList<KubeconfigUser>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public KubeConfigValue apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public KubeConfigValue clusters(@Nullable List<KubeconfigNamedCluster> clusters) {
        this.clusters = clusters;
        return this;
    }

    public KubeConfigValue addClustersItem(KubeconfigNamedCluster clustersItem) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<KubeconfigNamedCluster>();
        }
        this.clusters.add(clustersItem);
        return this;
    }

    @Nullable
    public List<KubeconfigNamedCluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(@Nullable List<KubeconfigNamedCluster> clusters) {
        this.clusters = clusters;
    }

    public KubeConfigValue contexts(@Nullable List<KubeconfigNamedContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    public KubeConfigValue addContextsItem(KubeconfigNamedContext contextsItem) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<KubeconfigNamedContext>();
        }
        this.contexts.add(contextsItem);
        return this;
    }

    @Nullable
    public List<KubeconfigNamedContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(@Nullable List<KubeconfigNamedContext> contexts) {
        this.contexts = contexts;
    }

    public KubeConfigValue currentContext(@Nullable String currentContext) {
        this.currentContext = currentContext;
        return this;
    }

    @Nullable
    public String getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(@Nullable String currentContext) {
        this.currentContext = currentContext;
    }

    public KubeConfigValue kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    public KubeConfigValue users(@Nullable List<KubeconfigUser> users) {
        this.users = users;
        return this;
    }

    public KubeConfigValue addUsersItem(KubeconfigUser usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<KubeconfigUser>();
        }
        this.users.add(usersItem);
        return this;
    }

    @Nullable
    public List<KubeconfigUser> getUsers() {
        return this.users;
    }

    public void setUsers(@Nullable List<KubeconfigUser> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubeConfigValue kubeConfigValue = (KubeConfigValue)o;
        return Objects.equals(this.apiVersion, kubeConfigValue.apiVersion) && Objects.equals(this.clusters, kubeConfigValue.clusters) && Objects.equals(this.contexts, kubeConfigValue.contexts) && Objects.equals(this.currentContext, kubeConfigValue.currentContext) && Objects.equals(this.kind, kubeConfigValue.kind) && Objects.equals(this.users, kubeConfigValue.users);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clusters, this.contexts, this.currentContext, this.kind, this.users);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KubeConfigValue {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    currentContext: ").append(this.toIndentedString(this.currentContext)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayusers;
        JsonArray jsonArraycontexts;
        int i;
        JsonArray jsonArrayclusters;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in KubeConfigValue is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `KubeConfigValue` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLUSTERS) != null && !jsonObj.get(SERIALIZED_NAME_CLUSTERS).isJsonNull() && (jsonArrayclusters = jsonObj.getAsJsonArray(SERIALIZED_NAME_CLUSTERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CLUSTERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `clusters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLUSTERS).toString()));
            }
            for (i = 0; i < jsonArrayclusters.size(); ++i) {
                KubeconfigNamedCluster.validateJsonElement(jsonArrayclusters.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTEXTS) != null && !jsonObj.get(SERIALIZED_NAME_CONTEXTS).isJsonNull() && (jsonArraycontexts = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTEXTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTEXTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `contexts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTEXTS).toString()));
            }
            for (i = 0; i < jsonArraycontexts.size(); ++i) {
                KubeconfigNamedContext.validateJsonElement(jsonArraycontexts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENT_CONTEXT) != null && !jsonObj.get(SERIALIZED_NAME_CURRENT_CONTEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENT_CONTEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `current-context` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENT_CONTEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERS) != null && !jsonObj.get(SERIALIZED_NAME_USERS).isJsonNull() && (jsonArrayusers = jsonObj.getAsJsonArray(SERIALIZED_NAME_USERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_USERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `users` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERS).toString()));
            }
            for (i = 0; i < jsonArrayusers.size(); ++i) {
                KubeconfigUser.validateJsonElement(jsonArrayusers.get(i));
            }
        }
    }

    public static KubeConfigValue fromJson(String jsonString) throws IOException {
        return (KubeConfigValue)JSON.getGson().fromJson(jsonString, KubeConfigValue.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_CLUSTERS);
        openapiFields.add(SERIALIZED_NAME_CONTEXTS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_CONTEXT);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_USERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!KubeConfigValue.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KubeConfigValue.class));
            return new TypeAdapter<KubeConfigValue>(){

                public void write(JsonWriter out, KubeConfigValue value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public KubeConfigValue read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    KubeConfigValue.validateJsonElement(jsonElement);
                    return (KubeConfigValue)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

