/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.akeyless.client.JSON;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class KMIPServer {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    @Nullable
    private Boolean active;
    public static final String SERIALIZED_NAME_CA = "ca";
    @SerializedName(value="ca")
    @Nullable
    private List<Integer> ca = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_CERTIFICATE = "certificate";
    @SerializedName(value="certificate")
    @Nullable
    private List<Integer> certificate = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_CERTIFICATE_ISSUE_DATE = "certificate_issue_date";
    @SerializedName(value="certificate_issue_date")
    @Nullable
    private OffsetDateTime certificateIssueDate;
    public static final String SERIALIZED_NAME_CERTIFICATE_TTL_IN_SECONDS = "certificate_ttl_in_seconds";
    @SerializedName(value="certificate_ttl_in_seconds")
    @Nullable
    private Long certificateTtlInSeconds;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    @Nullable
    private String hostname;
    public static final String SERIALIZED_NAME_ROOT = "root";
    @SerializedName(value="root")
    @Nullable
    private String root;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public KMIPServer active(@Nullable Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(@Nullable Boolean active) {
        this.active = active;
    }

    public KMIPServer ca(@Nullable List<Integer> ca) {
        this.ca = ca;
        return this;
    }

    public KMIPServer addCaItem(Integer caItem) {
        if (this.ca == null) {
            this.ca = new ArrayList<Integer>();
        }
        this.ca.add(caItem);
        return this;
    }

    @Nullable
    public List<Integer> getCa() {
        return this.ca;
    }

    public void setCa(@Nullable List<Integer> ca) {
        this.ca = ca;
    }

    public KMIPServer certificate(@Nullable List<Integer> certificate) {
        this.certificate = certificate;
        return this;
    }

    public KMIPServer addCertificateItem(Integer certificateItem) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Integer>();
        }
        this.certificate.add(certificateItem);
        return this;
    }

    @Nullable
    public List<Integer> getCertificate() {
        return this.certificate;
    }

    public void setCertificate(@Nullable List<Integer> certificate) {
        this.certificate = certificate;
    }

    public KMIPServer certificateIssueDate(@Nullable OffsetDateTime certificateIssueDate) {
        this.certificateIssueDate = certificateIssueDate;
        return this;
    }

    @Nullable
    public OffsetDateTime getCertificateIssueDate() {
        return this.certificateIssueDate;
    }

    public void setCertificateIssueDate(@Nullable OffsetDateTime certificateIssueDate) {
        this.certificateIssueDate = certificateIssueDate;
    }

    public KMIPServer certificateTtlInSeconds(@Nullable Long certificateTtlInSeconds) {
        this.certificateTtlInSeconds = certificateTtlInSeconds;
        return this;
    }

    @Nullable
    public Long getCertificateTtlInSeconds() {
        return this.certificateTtlInSeconds;
    }

    public void setCertificateTtlInSeconds(@Nullable Long certificateTtlInSeconds) {
        this.certificateTtlInSeconds = certificateTtlInSeconds;
    }

    public KMIPServer hostname(@Nullable String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(@Nullable String hostname) {
        this.hostname = hostname;
    }

    public KMIPServer root(@Nullable String root) {
        this.root = root;
        return this;
    }

    @Nullable
    public String getRoot() {
        return this.root;
    }

    public void setRoot(@Nullable String root) {
        this.root = root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KMIPServer kmIPServer = (KMIPServer)o;
        return Objects.equals(this.active, kmIPServer.active) && Objects.equals(this.ca, kmIPServer.ca) && Objects.equals(this.certificate, kmIPServer.certificate) && Objects.equals(this.certificateIssueDate, kmIPServer.certificateIssueDate) && Objects.equals(this.certificateTtlInSeconds, kmIPServer.certificateTtlInSeconds) && Objects.equals(this.hostname, kmIPServer.hostname) && Objects.equals(this.root, kmIPServer.root);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.ca, this.certificate, this.certificateIssueDate, this.certificateTtlInSeconds, this.hostname, this.root);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KMIPServer {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    ca: ").append(this.toIndentedString(this.ca)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    certificateIssueDate: ").append(this.toIndentedString(this.certificateIssueDate)).append("\n");
        sb.append("    certificateTtlInSeconds: ").append(this.toIndentedString(this.certificateTtlInSeconds)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    root: ").append(this.toIndentedString(this.root)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in KMIPServer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `KMIPServer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CA) != null && !jsonObj.get(SERIALIZED_NAME_CA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CA).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ca` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CERTIFICATE) != null && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CERTIFICATE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `certificate` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CERTIFICATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOT) != null && !jsonObj.get(SERIALIZED_NAME_ROOT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `root` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOT).toString()));
        }
    }

    public static KMIPServer fromJson(String jsonString) throws IOException {
        return (KMIPServer)JSON.getGson().fromJson(jsonString, KMIPServer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_CA);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_ISSUE_DATE);
        openapiFields.add(SERIALIZED_NAME_CERTIFICATE_TTL_IN_SECONDS);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_ROOT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!KMIPServer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KMIPServer.class));
            return new TypeAdapter<KMIPServer>(){

                public void write(JsonWriter out, KMIPServer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public KMIPServer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    KMIPServer.validateJsonElement(jsonElement);
                    return (KMIPServer)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

