/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="getCloudIdentity is a command that gets Cloud Identity Token (relevant only for access-type=azure_ad, aws_iam, gcp).")
public class GetCloudIdentity {
    public static final String SERIALIZED_NAME_AZURE_AD_OBJECT_ID = "azure_ad_object_id";
    @SerializedName(value="azure_ad_object_id")
    private String azureAdObjectId;
    public static final String SERIALIZED_NAME_DEBUG = "debug";
    @SerializedName(value="debug")
    private Boolean debug;
    public static final String SERIALIZED_NAME_GCP_AUDIENCE = "gcp-audience";
    @SerializedName(value="gcp-audience")
    private String gcpAudience;
    public static final String SERIALIZED_NAME_JSON = "json";
    @SerializedName(value="json")
    private Boolean json;
    public static final String SERIALIZED_NAME_URL_SAFE = "url_safe";
    @SerializedName(value="url_safe")
    private Boolean urlSafe;

    public GetCloudIdentity azureAdObjectId(String azureAdObjectId) {
        this.azureAdObjectId = azureAdObjectId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Azure Active Directory ObjectId (relevant only for access-type=azure_ad)")
    public String getAzureAdObjectId() {
        return this.azureAdObjectId;
    }

    public void setAzureAdObjectId(String azureAdObjectId) {
        this.azureAdObjectId = azureAdObjectId;
    }

    public GetCloudIdentity debug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public GetCloudIdentity gcpAudience(String gcpAudience) {
        this.gcpAudience = gcpAudience;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GCP JWT audience")
    public String getGcpAudience() {
        return this.gcpAudience;
    }

    public void setGcpAudience(String gcpAudience) {
        this.gcpAudience = gcpAudience;
    }

    public GetCloudIdentity json(Boolean json) {
        this.json = json;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set output format to JSON")
    public Boolean getJson() {
        return this.json;
    }

    public void setJson(Boolean json) {
        this.json = json;
    }

    public GetCloudIdentity urlSafe(Boolean urlSafe) {
        this.urlSafe = urlSafe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Escapes the token so it can be safely placed inside a URL query")
    public Boolean getUrlSafe() {
        return this.urlSafe;
    }

    public void setUrlSafe(Boolean urlSafe) {
        this.urlSafe = urlSafe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCloudIdentity getCloudIdentity = (GetCloudIdentity)o;
        return Objects.equals(this.azureAdObjectId, getCloudIdentity.azureAdObjectId) && Objects.equals(this.debug, getCloudIdentity.debug) && Objects.equals(this.gcpAudience, getCloudIdentity.gcpAudience) && Objects.equals(this.json, getCloudIdentity.json) && Objects.equals(this.urlSafe, getCloudIdentity.urlSafe);
    }

    public int hashCode() {
        return Objects.hash(this.azureAdObjectId, this.debug, this.gcpAudience, this.json, this.urlSafe);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetCloudIdentity {\n");
        sb.append("    azureAdObjectId: ").append(this.toIndentedString(this.azureAdObjectId)).append("\n");
        sb.append("    debug: ").append(this.toIndentedString(this.debug)).append("\n");
        sb.append("    gcpAudience: ").append(this.toIndentedString(this.gcpAudience)).append("\n");
        sb.append("    json: ").append(this.toIndentedString(this.json)).append("\n");
        sb.append("    urlSafe: ").append(this.toIndentedString(this.urlSafe)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

