/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="gatewayAddSubAdmins is a command that adds sub-admins")
public class GatewayAddSubAdmins {
    public static final String SERIALIZED_NAME_ALLOW_GW_API = "allow-gw-api";
    @SerializedName(value="allow-gw-api")
    private Boolean allowGwApi;
    public static final String SERIALIZED_NAME_ALLOW_GW_LOGIN = "allow-gw-login";
    @SerializedName(value="allow-gw-login")
    private Boolean allowGwLogin;
    public static final String SERIALIZED_NAME_GATEWAY_URL = "gateway-url";
    @SerializedName(value="gateway-url")
    private String gatewayUrl = "http://localhost:8000";
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_SUB_ADMIN_ACCESS_ID = "sub-admin-access-id";
    @SerializedName(value="sub-admin-access-id")
    private String subAdminAccessId;
    public static final String SERIALIZED_NAME_SUB_CLAIMS = "sub-claims";
    @SerializedName(value="sub-claims")
    private Map<String, String> subClaims = null;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_UID_TOKEN = "uid-token";
    @SerializedName(value="uid-token")
    private String uidToken;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;

    public GatewayAddSubAdmins allowGwApi(Boolean allowGwApi) {
        this.allowGwApi = allowGwApi;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getAllowGwApi() {
        return this.allowGwApi;
    }

    public void setAllowGwApi(Boolean allowGwApi) {
        this.allowGwApi = allowGwApi;
    }

    public GatewayAddSubAdmins allowGwLogin(Boolean allowGwLogin) {
        this.allowGwLogin = allowGwLogin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getAllowGwLogin() {
        return this.allowGwLogin;
    }

    public void setAllowGwLogin(Boolean allowGwLogin) {
        this.allowGwLogin = allowGwLogin;
    }

    public GatewayAddSubAdmins gatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gateway url")
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public void setGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    public GatewayAddSubAdmins password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required only when the authentication process requires a username and password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public GatewayAddSubAdmins subAdminAccessId(String subAdminAccessId) {
        this.subAdminAccessId = subAdminAccessId;
        return this;
    }

    @ApiModelProperty(required=true, value="SubAdmins to add")
    public String getSubAdminAccessId() {
        return this.subAdminAccessId;
    }

    public void setSubAdminAccessId(String subAdminAccessId) {
        this.subAdminAccessId = subAdminAccessId;
    }

    public GatewayAddSubAdmins subClaims(Map<String, String> subClaims) {
        this.subClaims = subClaims;
        return this;
    }

    public GatewayAddSubAdmins putSubClaimsItem(String key, String subClaimsItem) {
        if (this.subClaims == null) {
            this.subClaims = new HashMap<String, String>();
        }
        this.subClaims.put(key, subClaimsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="key/val of sub claims, e.g group=admins,developers")
    public Map<String, String> getSubClaims() {
        return this.subClaims;
    }

    public void setSubClaims(Map<String, String> subClaims) {
        this.subClaims = subClaims;
    }

    public GatewayAddSubAdmins token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authentication token (see `/auth` and `/configure`)")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public GatewayAddSubAdmins uidToken(String uidToken) {
        this.uidToken = uidToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The universal identity token, Required only for universal_identity authentication")
    public String getUidToken() {
        return this.uidToken;
    }

    public void setUidToken(String uidToken) {
        this.uidToken = uidToken;
    }

    public GatewayAddSubAdmins username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required only when the authentication process requires a username and password")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayAddSubAdmins gatewayAddSubAdmins = (GatewayAddSubAdmins)o;
        return Objects.equals(this.allowGwApi, gatewayAddSubAdmins.allowGwApi) && Objects.equals(this.allowGwLogin, gatewayAddSubAdmins.allowGwLogin) && Objects.equals(this.gatewayUrl, gatewayAddSubAdmins.gatewayUrl) && Objects.equals(this.password, gatewayAddSubAdmins.password) && Objects.equals(this.subAdminAccessId, gatewayAddSubAdmins.subAdminAccessId) && Objects.equals(this.subClaims, gatewayAddSubAdmins.subClaims) && Objects.equals(this.token, gatewayAddSubAdmins.token) && Objects.equals(this.uidToken, gatewayAddSubAdmins.uidToken) && Objects.equals(this.username, gatewayAddSubAdmins.username);
    }

    public int hashCode() {
        return Objects.hash(this.allowGwApi, this.allowGwLogin, this.gatewayUrl, this.password, this.subAdminAccessId, this.subClaims, this.token, this.uidToken, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GatewayAddSubAdmins {\n");
        sb.append("    allowGwApi: ").append(this.toIndentedString(this.allowGwApi)).append("\n");
        sb.append("    allowGwLogin: ").append(this.toIndentedString(this.allowGwLogin)).append("\n");
        sb.append("    gatewayUrl: ").append(this.toIndentedString(this.gatewayUrl)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    subAdminAccessId: ").append(this.toIndentedString(this.subAdminAccessId)).append("\n");
        sb.append("    subClaims: ").append(this.toIndentedString(this.subClaims)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    uidToken: ").append(this.toIndentedString(this.uidToken)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

