/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreateManagedKey is a command that creates managed key")
public class CreateManagedKey {
    public static final String SERIALIZED_NAME_ALG = "alg";
    @SerializedName(value="alg")
    private String alg;
    public static final String SERIALIZED_NAME_MANAGED_KEY_VALUE = "managed-key-value";
    @SerializedName(value="managed-key-value")
    private String managedKeyValue;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private String metadata;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PROTECTION_KEY = "protection_key";
    @SerializedName(value="protection_key")
    private String protectionKey;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_TARGET_NAME = "target-name";
    @SerializedName(value="target-name")
    private String targetName;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_UID_TOKEN = "uid-token";
    @SerializedName(value="uid-token")
    private String uidToken;

    public CreateManagedKey alg(String alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(required=true, value="Managed Key type; options: [AES256GCM, RSA2048]")
    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public CreateManagedKey managedKeyValue(String managedKeyValue) {
        this.managedKeyValue = managedKeyValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded managed key value")
    public String getManagedKeyValue() {
        return this.managedKeyValue;
    }

    public void setManagedKeyValue(String managedKeyValue) {
        this.managedKeyValue = managedKeyValue;
    }

    public CreateManagedKey metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Metadata about the managed key")
    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public CreateManagedKey name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="ManagedKey name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateManagedKey protectionKey(String protectionKey) {
        this.protectionKey = protectionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)")
    public String getProtectionKey() {
        return this.protectionKey;
    }

    public void setProtectionKey(String protectionKey) {
        this.protectionKey = protectionKey;
    }

    public CreateManagedKey tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateManagedKey addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of the tags attached to this managed key")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CreateManagedKey targetName(String targetName) {
        this.targetName = targetName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Target name")
    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public CreateManagedKey token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authentication token (see `/auth` and `/configure`)")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public CreateManagedKey uidToken(String uidToken) {
        this.uidToken = uidToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The universal identity token, Required only for universal_identity authentication")
    public String getUidToken() {
        return this.uidToken;
    }

    public void setUidToken(String uidToken) {
        this.uidToken = uidToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateManagedKey createManagedKey = (CreateManagedKey)o;
        return Objects.equals(this.alg, createManagedKey.alg) && Objects.equals(this.managedKeyValue, createManagedKey.managedKeyValue) && Objects.equals(this.metadata, createManagedKey.metadata) && Objects.equals(this.name, createManagedKey.name) && Objects.equals(this.protectionKey, createManagedKey.protectionKey) && Objects.equals(this.tags, createManagedKey.tags) && Objects.equals(this.targetName, createManagedKey.targetName) && Objects.equals(this.token, createManagedKey.token) && Objects.equals(this.uidToken, createManagedKey.uidToken);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.managedKeyValue, this.metadata, this.name, this.protectionKey, this.tags, this.targetName, this.token, this.uidToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateManagedKey {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    managedKeyValue: ").append(this.toIndentedString(this.managedKeyValue)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    protectionKey: ").append(this.toIndentedString(this.protectionKey)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    targetName: ").append(this.toIndentedString(this.targetName)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    uidToken: ").append(this.toIndentedString(this.uidToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

