/*
 * Decompiled with CFR 0.152.
 */
package io.akeyless.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AllowedAccessArgs {
    public static final String SERIALIZED_NAME_ACCESS_ID = "access-id";
    @SerializedName(value="access-id")
    private String accessId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    private String permissions;
    public static final String SERIALIZED_NAME_SUB_CLAIMS = "sub-claims";
    @SerializedName(value="sub-claims")
    private Map<String, String> subClaims = null;

    public AllowedAccessArgs accessId(String accessId) {
        this.accessId = accessId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Access ID The access id to be attached to this allowed access. Auth method with this access id should already exist.")
    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public AllowedAccessArgs description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allowed access description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AllowedAccessArgs name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Allowed access name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AllowedAccessArgs permissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Permissions  Comma-seperated list of permissions for this allowed access. Available permissions: [defaults,targets,classic_keys,automatic_migration,ldap_auth,dynamic_secret,k8s_auth,log_forwarding,zero_knowledge_encryption,rotated_secret,caching,event_forwarding,admin,kmip,general]")
    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public AllowedAccessArgs subClaims(Map<String, String> subClaims) {
        this.subClaims = subClaims;
        return this;
    }

    public AllowedAccessArgs putSubClaimsItem(String key, String subClaimsItem) {
        if (this.subClaims == null) {
            this.subClaims = new HashMap<String, String>();
        }
        this.subClaims.put(key, subClaimsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sub claims key/val of sub claims, e.g group=admins,developers")
    public Map<String, String> getSubClaims() {
        return this.subClaims;
    }

    public void setSubClaims(Map<String, String> subClaims) {
        this.subClaims = subClaims;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowedAccessArgs allowedAccessArgs = (AllowedAccessArgs)o;
        return Objects.equals(this.accessId, allowedAccessArgs.accessId) && Objects.equals(this.description, allowedAccessArgs.description) && Objects.equals(this.name, allowedAccessArgs.name) && Objects.equals(this.permissions, allowedAccessArgs.permissions) && Objects.equals(this.subClaims, allowedAccessArgs.subClaims);
    }

    public int hashCode() {
        return Objects.hash(this.accessId, this.description, this.name, this.permissions, this.subClaims);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AllowedAccessArgs {\n");
        sb.append("    accessId: ").append(this.toIndentedString(this.accessId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    subClaims: ").append(this.toIndentedString(this.subClaims)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

