/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.array.BooleanArrayMorpher;
import net.sf.ezmorph.array.ByteArrayMorpher;
import net.sf.ezmorph.array.CharArrayMorpher;
import net.sf.ezmorph.array.DoubleArrayMorpher;
import net.sf.ezmorph.array.FloatArrayMorpher;
import net.sf.ezmorph.array.IntArrayMorpher;
import net.sf.ezmorph.array.LongArrayMorpher;
import net.sf.ezmorph.array.ObjectArrayMorpher;
import net.sf.ezmorph.array.ShortArrayMorpher;
import net.sf.ezmorph.object.BooleanObjectMorpher;
import net.sf.ezmorph.object.CharacterObjectMorpher;
import net.sf.ezmorph.object.ClassMorpher;
import net.sf.ezmorph.object.NumberMorpher;
import net.sf.ezmorph.object.StringMorpher;
import net.sf.ezmorph.primitive.BooleanMorpher;
import net.sf.ezmorph.primitive.ByteMorpher;
import net.sf.ezmorph.primitive.CharMorpher;
import net.sf.ezmorph.primitive.DoubleMorpher;
import net.sf.ezmorph.primitive.FloatMorpher;
import net.sf.ezmorph.primitive.IntMorpher;
import net.sf.ezmorph.primitive.LongMorpher;
import net.sf.ezmorph.primitive.ShortMorpher;

public class MorphUtils {
    public static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");
    public static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0");

    public static void registerStandardMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.clear();
        MorphUtils.registerStandardPrimitiveMorphers(morpherRegistry);
        MorphUtils.registerStandardPrimitiveArrayMorphers(morpherRegistry);
        MorphUtils.registerStandardObjectMorphers(morpherRegistry);
        MorphUtils.registerStandardObjectArrayMorphers(morpherRegistry);
    }

    public static void registerStandardObjectArrayMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new BooleanObjectMorpher(Boolean.FALSE)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new CharacterObjectMorpher(new Character('\u0000'))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(StringMorpher.getInstance()));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Byte.class, new Byte(0))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Short.class, new Short(0))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Integer.class, new Integer(0))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Long.class, new Long(0L))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Float.class, new Float(0.0f))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Double.class, new Double(0.0))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(BigInteger.class, BigInteger.ZERO)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(BigDecimal.class, BIGDECIMAL_ZERO)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(ClassMorpher.getInstance()));
    }

    public static void registerStandardObjectMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanObjectMorpher(Boolean.FALSE));
        morpherRegistry.registerMorpher(new CharacterObjectMorpher(new Character('\u0000')));
        morpherRegistry.registerMorpher(StringMorpher.getInstance());
        morpherRegistry.registerMorpher(new NumberMorpher(Byte.class, new Byte(0)));
        morpherRegistry.registerMorpher(new NumberMorpher(Short.class, new Short(0)));
        morpherRegistry.registerMorpher(new NumberMorpher(Integer.class, new Integer(0)));
        morpherRegistry.registerMorpher(new NumberMorpher(Long.class, new Long(0L)));
        morpherRegistry.registerMorpher(new NumberMorpher(Float.class, new Float(0.0f)));
        morpherRegistry.registerMorpher(new NumberMorpher(Double.class, new Double(0.0)));
        morpherRegistry.registerMorpher(new NumberMorpher(BigInteger.class, BigInteger.ZERO));
        morpherRegistry.registerMorpher(new NumberMorpher(BigDecimal.class, BIGDECIMAL_ZERO));
        morpherRegistry.registerMorpher(ClassMorpher.getInstance());
    }

    public static void registerStandardPrimitiveArrayMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanArrayMorpher(false));
        morpherRegistry.registerMorpher(new CharArrayMorpher('\u0000'));
        morpherRegistry.registerMorpher(new ByteArrayMorpher(0));
        morpherRegistry.registerMorpher(new ShortArrayMorpher(0));
        morpherRegistry.registerMorpher(new IntArrayMorpher(0));
        morpherRegistry.registerMorpher(new LongArrayMorpher(0L));
        morpherRegistry.registerMorpher(new FloatArrayMorpher(0.0f));
        morpherRegistry.registerMorpher(new DoubleArrayMorpher(0.0));
    }

    public static void registerStandardPrimitiveMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanMorpher(false));
        morpherRegistry.registerMorpher(new CharMorpher('\u0000'));
        morpherRegistry.registerMorpher(new ByteMorpher(0));
        morpherRegistry.registerMorpher(new ShortMorpher(0));
        morpherRegistry.registerMorpher(new IntMorpher(0));
        morpherRegistry.registerMorpher(new LongMorpher(0L));
        morpherRegistry.registerMorpher(new FloatMorpher(0.0f));
        morpherRegistry.registerMorpher(new DoubleMorpher(0.0));
    }

    private MorphUtils() {
    }
}

