/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.model;

import com.acunetix.model.ProxyBlock;
import com.acunetix.model.ScanReport;
import com.acunetix.model.ScanRequestBase;
import com.acunetix.utility.AppCommon;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.json.simple.parser.ParseException;

public class ScanRequestResult
extends ScanRequestBase {
    private String scanReportEndpoint;
    private final int httpStatusCode;
    private String data;
    private String scanTaskID;
    private boolean isError;
    private String errorMessage;
    private ScanReport report = null;
    private Date previousRequestTime;

    public static ScanRequestResult errorResult(String errorMessage) {
        return new ScanRequestResult(errorMessage);
    }

    private ScanRequestResult(String errorMessage) {
        this.errorMessage = errorMessage;
        this.httpStatusCode = 0;
        this.isError = true;
        this.data = "";
    }

    public ScanRequestResult(ClassicHttpResponse response, String apiURL, Secret apiToken, String ncReportType, ProxyBlock proxy) throws MalformedURLException, URISyntaxException {
        super(apiURL, apiToken, proxy);
        this.httpStatusCode = response.getCode();
        boolean bl = this.isError = this.httpStatusCode != 201;
        if (!this.isError) {
            try {
                this.data = AppCommon.parseResponseToString(response);
                boolean bl2 = this.isError = (Boolean)AppCommon.parseJsonValue(this.data, "IsValid") == false;
                if (!this.isError) {
                    this.scanTaskID = (String)AppCommon.parseJsonValue(this.data, "ScanTaskId");
                } else {
                    this.errorMessage = (String)AppCommon.parseJsonValue(this.data, "ErrorMessage");
                }
            }
            catch (ParseException ex) {
                this.isError = true;
                this.errorMessage = "Scan request result is not parsable::: " + ex.toString();
            }
            catch (IOException ex) {
                this.isError = true;
                this.errorMessage = "Scan request result is not readable::: " + ex.toString();
            }
        }
        String scanReportRelativeUrl = "api/1.0/scans/report/";
        URI scanReportEndpointUri = new URL(this.ApiURL, scanReportRelativeUrl).toURI();
        HashMap<String, String> queryparams = new HashMap<String, String>();
        String reportType = ncReportType == null || ncReportType.equals("null") ? "ExecutiveSummary" : ncReportType;
        queryparams.put("Type", reportType);
        queryparams.put("Format", "Html");
        queryparams.put("Id", this.scanTaskID);
        this.scanReportEndpoint = scanReportEndpointUri.toString() + "?" + AppCommon.mapToQueryString(queryparams);
    }

    public String getScanTaskId() {
        return this.scanTaskID;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isReportGenerated() {
        if (this.isError()) {
            return false;
        }
        if (this.isReportAvailable()) {
            return true;
        }
        if (this.canAskForReportFromNCCloud()) {
            try {
                ScanReport report = this.getReport();
                return report.isReportGenerated();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public ScanReport getReport() {
        if (this.canAskForReportFromNCCloud()) {
            ScanReport reportFromNcCloud = this.getReportFromNcCloud();
            this.previousRequestTime = new Date();
            this.report = reportFromNcCloud;
            return this.report;
        }
        return this.report;
    }

    private boolean canAskForReportFromNCCloud() {
        Date now = new Date();
        boolean isTimeThresholdPassed = this.previousRequestTime == null || now.getTime() - this.previousRequestTime.getTime() >= 60000L;
        return isTimeThresholdPassed || !this.isReportAvailable();
    }

    private boolean isReportAvailable() {
        return this.report != null && this.report.isReportGenerated();
    }

    private ScanReport getReportFromNcCloud() {
        ScanReport reportFromApi;
        if (!this.isError) {
            try {
                CloseableHttpClient httpClient = this.getHttpClient();
                HttpGet httpGet = new HttpGet(this.scanReportEndpoint);
                httpGet.setHeader("Authorization", (Object)this.getAuthHeader());
                ClassicHttpResponse response = (ClassicHttpResponse)httpClient.execute((ClassicHttpRequest)httpGet);
                reportFromApi = new ScanReport(response, this.scanReportEndpoint);
            }
            catch (IOException ex) {
                String reportRequestErrorMessage = "Report result is not readable::: " + ex.toString();
                reportFromApi = new ScanReport(false, "", true, reportRequestErrorMessage, this.scanReportEndpoint);
            }
        } else {
            reportFromApi = new ScanReport(true, this.errorMessage, false, "", this.scanReportEndpoint);
        }
        this.report = reportFromApi;
        return reportFromApi;
    }
}

