/*
 * Decompiled with CFR 0.152.
 */
package com.acunetix.model;

import com.acunetix.model.ProxyBlock;
import com.acunetix.model.ScanRequestBase;
import com.acunetix.model.ScanType;
import com.acunetix.model.VCSCommit;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class ScanRequest
extends ScanRequestBase {
    public final ScanType scanType;
    public final String websiteId;
    public final String profileId;
    public final VCSCommit vcsCommit;
    public final URI scanUri;
    public final URI testUri;

    public ScanRequest(String apiURL, Secret apiToken, String scanType, String websiteId, String profileId, VCSCommit vcsCommit, ProxyBlock proxy) throws MalformedURLException, NullPointerException, URISyntaxException {
        super(apiURL, apiToken, proxy);
        this.scanType = ScanType.valueOf(scanType);
        this.websiteId = websiteId;
        this.profileId = profileId;
        this.vcsCommit = vcsCommit;
        this.scanUri = new URL(this.ApiURL, "api/1.0/scans/CreateFromPluginScanRequest").toURI();
        this.testUri = new URL(this.ApiURL, "api/1.0/scans/VerifyPluginScanRequest").toURI();
    }

    public ClassicHttpResponse scanRequest() throws IOException {
        CloseableHttpClient client = this.getHttpClient();
        HttpPost httpPost = new HttpPost(this.scanUri);
        httpPost.setHeader("Accept", (Object)"application/json");
        httpPost.setHeader("Authorization", (Object)this.getAuthHeader());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.setScanParams(params);
        this.vcsCommit.addVcsCommitInfo(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return (ClassicHttpResponse)client.execute((ClassicHttpRequest)httpPost);
    }

    public ClassicHttpResponse testRequest() throws IOException {
        CloseableHttpClient client = this.getHttpClient();
        HttpPost httpPost = new HttpPost(this.testUri);
        httpPost.setHeader("Accept", (Object)"application/json");
        httpPost.setHeader("Authorization", (Object)this.getAuthHeader());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.setScanParams(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return (ClassicHttpResponse)client.execute((ClassicHttpRequest)httpPost);
    }

    private void setScanParams(List<NameValuePair> params) {
        switch (this.scanType) {
            case Incremental: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ProfileId", this.profileId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "Incremental"));
                break;
            }
            case FullWithPrimaryProfile: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "FullWithPrimaryProfile"));
                break;
            }
            case FullWithSelectedProfile: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ProfileId", this.profileId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "FullWithSelectedProfile"));
            }
        }
    }
}

