/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

class LDAPSearchBuilder {
    private static final Logger LOG = Logger.getLogger(LDAPSearchBuilder.class.getName());
    private final DirContext context;
    private final String baseDN;
    private final SearchControls controls = new SearchControls();

    public LDAPSearchBuilder(DirContext context, String baseDN) {
        this.context = context;
        this.baseDN = baseDN;
    }

    public LDAPSearchBuilder objectScope() {
        this.controls.setSearchScope(0);
        return this;
    }

    public LDAPSearchBuilder subTreeScope() {
        this.controls.setSearchScope(2);
        return this;
    }

    public LDAPSearchBuilder returns(String ... attributes) {
        this.controls.setReturningAttributes(attributes);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes searchOne(String filter, Object ... args) throws NamingException {
        try (NamingEnumeration<SearchResult> r = this.search(filter, args);){
            if (r.hasMore()) {
                SearchResult searchResult = r.next();
                Attributes attrs = searchResult.getAttributes();
                attrs.put("distinguishedNameFormatted", searchResult.getNameInNamespace());
                LOG.log(Level.FINER, "found {0}", attrs);
                Attributes attributes = attrs;
                return attributes;
            }
            LOG.finer("no result");
            Attributes searchResult = null;
            return searchResult;
        }
    }

    public NamingEnumeration<SearchResult> search(String filter, Object ... args) throws NamingException {
        if (LOG.isLoggable(Level.FINER)) {
            HashMap env = new HashMap(this.context.getEnvironment());
            if (env.containsKey("java.naming.security.credentials")) {
                env.put("java.naming.security.credentials", "\u2026");
            }
            LOG.log(Level.FINER, "searching {0}{1} in {2} using {3} with scope {4} returning {5}", new Object[]{filter, Arrays.toString(args), this.baseDN, env, this.controls.getSearchScope(), Arrays.toString(this.controls.getReturningAttributes())});
        }
        return this.context.search(this.baseDN, filter, args, this.controls);
    }
}

