/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.ComThread;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Task<T>
implements Callable<T> {
    private volatile boolean done = false;
    T result;
    Throwable exception;
    Error error;

    Task() {
    }

    @Override
    public abstract T call();

    public final T execute() {
        if (ComThread.isComThread()) {
            return this.call();
        }
        return ComThread.get().execute(this);
    }

    public final T execute(ComThread t) {
        if (Thread.currentThread() == t) {
            return this.call();
        }
        return t.execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void invoke() {
        this.result = null;
        this.exception = null;
        try {
            this.result = this.call();
        }
        catch (Throwable e) {
            this.exception = e;
        }
        finally {
            this.done = true;
        }
        this.notify();
    }

    final boolean isDone() {
        return this.done;
    }

    final void reset() {
        this.done = false;
    }
}

