/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComObjectListener;
import com4j.ExecutionException;
import com4j.Native;
import com4j.NativePointerPhantomReference;
import com4j.Task;
import com4j.Win32Lock;
import com4j.Wrapper;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComThread
extends Thread {
    public static int GARBAGE_COLLECTION_INTERVAL = 10;
    private static final ThreadLocal<ComThread> map = new ThreadLocal<ComThread>(){

        @Override
        public ComThread initialValue() {
            if (ComThread.isComThread()) {
                return (ComThread)Thread.currentThread();
            }
            return new ComThread(Thread.currentThread());
        }
    };
    private final Thread peer;
    private final List<Task<?>> taskList = Collections.synchronizedList(new LinkedList());
    private Set<NativePointerPhantomReference> liveComObjects = new HashSet<NativePointerPhantomReference>();
    final ReferenceQueue<Wrapper> collectableObjects = new ReferenceQueue();
    private final List<ComObjectListener> listeners = new ArrayList<ComObjectListener>();
    private volatile boolean die = false;
    private final Win32Lock lock = new Win32Lock();
    static final Set<ComThread> threads = Collections.synchronizedSet(new HashSet());

    static ComThread get() {
        return map.get();
    }

    static void detach() {
        map.get().kill();
        try {
            map.get().join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        map.remove();
    }

    private ComThread(Thread peer) {
        super("ComThread for " + peer.getName());
        this.peer = peer;
        this.setDaemon(true);
        this.start();
    }

    private boolean canExit() {
        return this.die || !this.peer.isAlive() && this.liveComObjects.isEmpty();
    }

    public void kill() {
        this.die = true;
        this.lock.activate();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        threads.add(this);
        try {
            this.run0();
        }
        finally {
            threads.remove(this);
        }
    }

    private void run0() {
        Native.coInitialize();
        while (!this.canExit()) {
            this.lock.suspend(GARBAGE_COLLECTION_INTERVAL);
            this.collectGarbage();
            while (!this.taskList.isEmpty()) {
                Task<?> task = this.taskList.get(0);
                this.taskList.remove(0);
                task.invoke();
                this.collectGarbage();
            }
        }
        this.collectGarbage();
        for (NativePointerPhantomReference ref : this.liveComObjects) {
            ref.clear();
            ref.releaseNative();
        }
        this.liveComObjects.clear();
        this.lock.dispose();
        Native.coUninitialize();
    }

    private void collectGarbage() {
        NativePointerPhantomReference toCollect;
        while ((toCollect = (NativePointerPhantomReference)this.collectableObjects.poll()) != null) {
            this.liveComObjects.remove(toCollect);
            toCollect.clear();
            toCollect.releaseNative();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Task<T> task) {
        Task<T> task2 = task;
        synchronized (task2) {
            task.reset();
            this.taskList.add(task);
            this.lock.activate();
            try {
                while (!task.isDone()) {
                    task.wait();
                }
            }
            catch (InterruptedException e) {
                task.exception = e;
            }
            if (task.exception != null) {
                Throwable e = task.exception;
                task.exception = null;
                throw new ExecutionException(e);
            }
            Object r = task.result;
            task.result = null;
            return r;
        }
    }

    public synchronized void addLiveObject(Com4jObject r) {
        if (r instanceof Wrapper) {
            this.liveComObjects.add(((Wrapper)r).ref);
        }
        if (!this.listeners.isEmpty()) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).onNewObject(r);
            }
        }
    }

    static boolean isComThread() {
        return Thread.currentThread() instanceof ComThread;
    }

    public void addListener(ComObjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("can't register the same listener twice");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ComObjectListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("listener isn't registered");
        }
    }

    public static void flushFreeList() {
        System.gc();
        ComThread.get().lock.activate();
    }

    static {
        COM4J.addCom4JShutdownTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ComThread[] threadsSnapshot;
                Set<ComThread> set = threads;
                synchronized (set) {
                    threadsSnapshot = threads.toArray(new ComThread[threads.size()]);
                }
                for (ComThread thread : threadsSnapshot) {
                    thread.kill();
                }
            }
        });
    }
}

