/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.MethodIntrospector;
import com4j.NativeType;
import com4j.ReturnValue;
import com4j.StandardComMethod;
import com4j.VTID;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CallbackBuilder {
    CallbackBuilder() {
    }

    void build(Class<? extends Com4jObject> type) {
        MethodTable table = new MethodTable();
        this.build(type, table);
    }

    private void build(Class<? extends Com4jObject> type, MethodTable table) {
        if (type == Com4jObject.class) {
            return;
        }
        for (Method method : type.getDeclaredMethods()) {
            ReturnValue retVal;
            VTID vtid = method.getAnnotation(VTID.class);
            if (vtid == null || (retVal = method.getAnnotation(ReturnValue.class)) != null && retVal.defaultPropertyThrough().length != 0) continue;
            table.set(vtid.value(), method);
        }
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            this.build((Class<? extends Com4jObject>)genericDeclaration, table);
        }
    }

    class Invoker {
        private final Method method;
        private final NativeType[] params;
        public final int[] paramConvs;
        private final Class<?>[] paramTypes;
        private final Type[] paramGenTypes;
        private final NativeType retConv;
        private final int retIndex;

        public Invoker(Method method) {
            this.method = method;
            this.paramTypes = method.getParameterTypes();
            this.paramGenTypes = method.getGenericParameterTypes();
            ReturnValue retVal = method.getAnnotation(ReturnValue.class);
            Class<?> retType = method.getReturnType();
            if (retType == Void.TYPE) {
                this.retConv = null;
                this.retIndex = -1;
            } else {
                int i;
                this.retConv = retVal != null && retVal.inout() ? null : StandardComMethod.getDefaultConversion(retType);
                int n = i = retVal != null ? retVal.index() : -1;
                if (i == -1) {
                    i = this.paramTypes.length;
                }
                this.retIndex = i;
            }
            MethodIntrospector mi = new MethodIntrospector(method);
            this.params = new NativeType[mi.paramLength()];
            this.paramConvs = new int[mi.paramLength()];
            for (int i = 0; i < mi.paramLength(); ++i) {
                NativeType n;
                this.params[i] = n = mi.getParamConversation(i);
                this.paramConvs[i] = n.code;
            }
        }

        Object invoke(Object target, Object[] args) throws IllegalAccessException, InvocationTargetException {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.params[i].toJava(this.paramTypes[i], this.paramGenTypes[i], args[i]);
            }
            Object ret = this.method.invoke(target, args);
            if (this.retConv != null) {
                ret = this.retConv.toNative(ret);
            }
            return ret;
        }

        int getArgSize() {
            int sz = 0;
            for (NativeType n : this.params) {
                sz += n.size;
            }
            if (this.retIndex == this.params.length) {
                sz += this.retConv.size;
            }
            return sz;
        }
    }

    class MethodTable {
        private Method[] comMethods = new Method[32];
        private int tableSize = 3;

        MethodTable() {
        }

        public void set(int idx, Method m) {
            if (this.tableSize <= idx) {
                Method[] buf = new Method[Math.max(idx + 1, this.comMethods.length * 2)];
                System.arraycopy(this.comMethods, 0, buf, 0, this.tableSize);
                this.comMethods = buf;
            }
            this.comMethods[idx] = m;
            this.tableSize = Math.max(this.tableSize, idx + 1);
        }
    }
}

