/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter.strategy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.sorter.SorterStrategy;
import jenkins.advancedqueue.sorter.SorterStrategyDescriptor;
import org.kohsuke.stapler.QueryParameter;

public abstract class MultiBucketStrategy
extends SorterStrategy {
    public static final int DEFAULT_PRIORITIES_NUMBER = 5;
    public static final int DEFAULT_PRIORITY = 3;
    private final int numberOfPriorities;
    private final int defaultPriority;

    public MultiBucketStrategy() {
        this(5, 3);
    }

    public MultiBucketStrategy(int numberOfPriorities, int defaultPriority) {
        this.numberOfPriorities = numberOfPriorities;
        this.defaultPriority = defaultPriority;
    }

    @Override
    public final int getNumberOfPriorities() {
        return this.numberOfPriorities;
    }

    @Override
    public final int getDefaultPriority() {
        return this.defaultPriority;
    }

    public ListBoxModel doFillDefaultPriorityItems() {
        throw new RuntimeException();
    }

    public static abstract class MultiBucketStrategyDescriptor
    extends SorterStrategyDescriptor {
        public ListBoxModel doUpdateDefaultPriorityItems(@QueryParameter(value="value") String strValue) {
            int value = 3;
            try {
                value = Integer.parseInt(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ListBoxModel items = this.internalFillDefaultPriorityItems(value);
            return items;
        }

        public ListBoxModel doDefaultPriority(@QueryParameter(value="value") String value) throws IOException, ServletException {
            return this.doUpdateDefaultPriorityItems(value);
        }

        private ListBoxModel internalFillDefaultPriorityItems(int value) {
            ListBoxModel items = new ListBoxModel();
            for (int i = 1; i <= value; ++i) {
                items.add(String.valueOf(i));
            }
            return items;
        }

        @CheckForNull
        MultiBucketStrategy getStrategy() {
            SorterStrategy strategy = PrioritySorterConfiguration.get().getStrategy();
            if (strategy == null || !(strategy instanceof MultiBucketStrategy)) {
                return null;
            }
            return (MultiBucketStrategy)strategy;
        }

        public ListBoxModel doFillDefaultPriorityItems() {
            MultiBucketStrategy strategy = this.getStrategy();
            if (strategy == null) {
                return this.internalFillDefaultPriorityItems(5);
            }
            return this.internalFillDefaultPriorityItems(strategy.getNumberOfPriorities());
        }

        public int getDefaultPrioritiesNumber() {
            MultiBucketStrategy strategy = this.getStrategy();
            if (strategy == null) {
                return 5;
            }
            return strategy.getNumberOfPriorities();
        }

        public int getDefaultPriority() {
            MultiBucketStrategy strategy = this.getStrategy();
            if (strategy == null) {
                return 3;
            }
            return strategy.getDefaultPriority();
        }
    }
}

