/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter;

import hudson.model.Queue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jenkins.advancedqueue.DecisionLogger;
import jenkins.advancedqueue.ItemTransitionLogger;
import jenkins.advancedqueue.PriorityConfigurationCallback;
import jenkins.advancedqueue.priority.PriorityStrategy;
import jenkins.advancedqueue.sorter.ItemStatus;
import jenkins.advancedqueue.sorter.SorterStrategyCallback;

public class ItemInfo
implements PriorityConfigurationCallback,
DecisionLogger,
SorterStrategyCallback,
Comparable<ItemInfo> {
    private long itemId;
    private long inQueueSince;
    private Long sortAsInQueueSince = null;
    private int jobGroupId;
    private PriorityStrategy priorityStrategy;
    private String jobName;
    private float weight;
    private int priority;
    private ItemStatus itemStatus;
    private List<String> decisionLog = new ArrayList<String>(10);

    ItemInfo(Queue.Item item) {
        this.itemId = item.getId();
        this.inQueueSince = item.getInQueueSince();
        this.jobName = item.task.getName();
        this.itemStatus = ItemStatus.WAITING;
    }

    @Override
    public PriorityConfigurationCallback setPrioritySelection(int priority, int jobGroupId, PriorityStrategy reason) {
        this.priority = priority;
        this.jobGroupId = jobGroupId;
        this.priorityStrategy = reason;
        return this;
    }

    @Override
    public PriorityConfigurationCallback setPrioritySelection(int priority, long sortAsInQueueSince, int jobGroupId, PriorityStrategy reason) {
        this.priority = priority;
        this.sortAsInQueueSince = sortAsInQueueSince;
        this.jobGroupId = jobGroupId;
        this.priorityStrategy = reason;
        return this;
    }

    @Override
    public PriorityConfigurationCallback addDecisionLog(int indent, String log) {
        this.decisionLog.add(this.formatLogEntry(indent, log));
        return this;
    }

    @Override
    public PriorityConfigurationCallback setPrioritySelection(int priority) {
        this.setPrioritySelection(priority, -1, null);
        return this;
    }

    @Override
    public SorterStrategyCallback setWeightSelection(float weight) {
        this.weight = weight;
        return this;
    }

    public void setBuildable() {
        this.itemStatus = ItemStatus.BUILDABLE;
        ItemTransitionLogger.logBuilableItem(this);
    }

    public void setBlocked() {
        this.itemStatus = ItemStatus.BLOCKED;
        ItemTransitionLogger.logBlockedItem(this);
    }

    public long getItemId() {
        return this.itemId;
    }

    public long getInQueueSince() {
        return this.inQueueSince;
    }

    public long getSortableInQueueSince() {
        if (this.sortAsInQueueSince != null) {
            return this.sortAsInQueueSince;
        }
        return this.inQueueSince;
    }

    public int getJobGroupId() {
        return this.jobGroupId;
    }

    public PriorityStrategy getPriorityStrategy() {
        return this.priorityStrategy;
    }

    public String getJobName() {
        return this.jobName;
    }

    public float getWeight() {
        return this.weight;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public ItemStatus getItemStatus() {
        return this.itemStatus;
    }

    @Override
    public int compareTo(ItemInfo o) {
        if (this.getWeight() == o.getWeight()) {
            if (this.getSortableInQueueSince() == o.getSortableInQueueSince()) {
                return Long.compare(this.getItemId(), o.getItemId());
            }
            return Long.compare(this.getSortableInQueueSince(), o.getSortableInQueueSince());
        }
        return Float.compare(this.getWeight(), o.getWeight());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemInfo) {
            ItemInfo itemInfo = (ItemInfo)obj;
            return this.compareTo(itemInfo) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemId, this.inQueueSince, this.sortAsInQueueSince, this.jobGroupId, this.priorityStrategy, this.jobName, Float.valueOf(this.weight), this.priority, this.itemStatus, this.decisionLog});
    }

    public String toString() {
        String reason = "<none>";
        if (this.priorityStrategy != null) {
            reason = this.priorityStrategy.getDescriptor().getDisplayName();
        }
        return "Id: %s, JobName: %s, jobGroupId: %s, reason: %s, priority: %s, weight: %s, status: %s".formatted(new Object[]{this.itemId, this.jobName, this.jobGroupId, reason, this.priority, Float.valueOf(this.weight), this.itemStatus});
    }

    public String getDescisionLog() {
        return this.decisionLog.isEmpty() ? "" : String.join((CharSequence)"\n", this.decisionLog) + "\n";
    }

    private String formatLogEntry(int indent, String log) {
        int spaces = Math.max(0, (indent + 1) * 2);
        if (spaces == 0) {
            return log;
        }
        return ("%" + spaces + "s%s").formatted("", log);
    }
}

