/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.queue.QueueSorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.advancedqueue.ItemTransitionLogger;
import jenkins.advancedqueue.PriorityConfiguration;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.sorter.ItemInfo;
import jenkins.advancedqueue.sorter.QueueItemCache;
import jenkins.advancedqueue.sorter.SorterStrategy;
import jenkins.advancedqueue.sorter.StartedJobItemCache;

@Extension
public class AdvancedQueueSorter
extends QueueSorter {
    private static final Logger LOGGER = Logger.getLogger("PrioritySorter.Queue.Sorter");

    public static void init() {
        List items = Queue.getInstance().getBuildableItems();
        Collections.sort(items, Comparator.comparingLong(Queue.Item::getInQueueSince));
        AdvancedQueueSorter advancedQueueSorter = AdvancedQueueSorter.get();
        for (Queue.BuildableItem item : items) {
            advancedQueueSorter.onNewItem((Queue.Item)item);
            ItemInfo info = QueueItemCache.get().getItem(item.getId());
            if (info == null) continue;
            info.setBuildable();
        }
        LOGGER.log(Level.INFO, "Initialized the QueueSorter with {0} Buildable Items", items.size());
    }

    public void sortNotWaitingItems(List<? extends Queue.NotWaitingItem> items) {
        Collections.sort(items, (o1, o2) -> {
            ItemInfo item1 = QueueItemCache.get().getItem(o1.getId());
            ItemInfo item2 = QueueItemCache.get().getItem(o2.getId());
            if (item1 == null || item2 == null) {
                LOGGER.warning("Requested to sort unknown items, sorting on queue-time only.");
                return Long.compare(o1.getInQueueSince(), o2.getInQueueSince());
            }
            return item1.compareTo(item2);
        });
        if (!items.isEmpty() && LOGGER.isLoggable(Level.FINE)) {
            ItemInfo minItem = QueueItemCache.get().getItem(items.get(0).getId());
            ItemInfo maxItem = QueueItemCache.get().getItem(items.get(items.size() - 1).getId());
            float minWeight = minItem != null ? minItem.getWeight() : 0.0f;
            float maxWeight = maxItem != null ? maxItem.getWeight() : 0.0f;
            LOGGER.log(Level.FINE, "Sorted {0} {1}s with Min Weight {2} and Max Weight {3}", new Object[]{items.size(), items.get(0).getClass().getName(), Float.valueOf(minWeight), Float.valueOf(maxWeight)});
        }
        if (!items.isEmpty() && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, this.buildQueueTable(items));
        }
    }

    public void sortBuildableItems(List<Queue.BuildableItem> items) {
        this.sortNotWaitingItems(items);
    }

    public void sortBlockedItems(List<Queue.BlockedItem> blockedItems) {
        this.sortNotWaitingItems(blockedItems);
    }

    public void onNewItem(@NonNull Queue.Item item) {
        SorterStrategy prioritySorterStrategy = PrioritySorterConfiguration.get().getStrategy();
        ItemInfo itemInfo = new ItemInfo(item);
        PriorityConfiguration.get().getPriority(item, itemInfo);
        prioritySorterStrategy.onNewItem(item, itemInfo);
        QueueItemCache.get().addItem(itemInfo);
        ItemTransitionLogger.logNewItem(itemInfo);
    }

    public void onLeft(@NonNull Queue.LeftItem li) {
        ItemInfo itemInfo = QueueItemCache.get().removeItem(li.getId());
        if (itemInfo == null) {
            LOGGER.log(Level.WARNING, "Received the onLeft() notification for the item from outside the QueueItemCache: {0}. Cannot process this item, Priority Sorter Strategy will not be invoked", li);
            return;
        }
        SorterStrategy prioritySorterStrategy = PrioritySorterConfiguration.get().getStrategy();
        if (li.isCancelled()) {
            prioritySorterStrategy.onCanceledItem(li);
            ItemTransitionLogger.logCanceledItem(itemInfo);
        } else {
            Float weight = Float.valueOf(itemInfo.getWeight());
            StartedJobItemCache.get().addItem(itemInfo, li.outcome.getPrimaryWorkUnit());
            prioritySorterStrategy.onStartedItem(li, weight.floatValue());
            ItemTransitionLogger.logStartedItem(itemInfo);
        }
    }

    public static AdvancedQueueSorter get() {
        return (AdvancedQueueSorter)((Object)QueueSorter.all().get(AdvancedQueueSorter.class));
    }

    private String buildQueueTable(List<? extends Queue.NotWaitingItem> items) {
        String header = "%s Queue:%n+----------------------------------------------------------------------+%n|   Item Id  |        Job Name       | Priority |        Weight        |%n+----------------------------------------------------------------------+%n";
        String formattedHeader = header.formatted(items.get(0).getClass().getName());
        String tableRows = items.stream().map(this::formatQueueItem).collect(Collectors.joining());
        return formattedHeader + tableRows + "+----------------------------------------------------------------------+";
    }

    private String formatQueueItem(Queue.NotWaitingItem item) {
        ItemInfo itemInfo = QueueItemCache.get().getItem(item.getId());
        String itemName = itemInfo != null ? itemInfo.getJobName() : item.task.getName();
        int itemPriority = itemInfo != null ? itemInfo.getPriority() : 0;
        float itemWeight = itemInfo != null ? itemInfo.getWeight() : 0.0f;
        String jobName = this.truncateJobName(itemName);
        return "| %10d | %20s | %8d | %20.5f |%n".formatted(item.getId(), jobName, itemPriority, Float.valueOf(itemWeight));
    }

    private String truncateJobName(String jobName) {
        return jobName.length() > 21 ? "%s...%s".formatted(jobName.substring(0, 9), jobName.substring(jobName.length() - 9)) : jobName;
    }
}

