/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.priority.strategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.logging.Logger;
import jenkins.advancedqueue.JobGroup;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PriorityConfiguration;
import jenkins.advancedqueue.PriorityConfigurationCallback;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.priority.PriorityStrategy;
import jenkins.advancedqueue.priority.strategy.JobPropertyStrategy;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class PriorityJobProperty
extends JobProperty<Job<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(PriorityJobProperty.class.getName());
    public final boolean useJobPriority;
    public final int priority;

    public JobProperty<?> reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        return super.reconfigure(req, form);
    }

    @DataBoundConstructor
    public PriorityJobProperty(boolean useJobPriority, int priority) {
        this.useJobPriority = useJobPriority;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean getUseJobPriority() {
        return this.useJobPriority;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Commont pattern in Jenkins")
        private PriorityConfigurationCallback dummyCallback = new PriorityConfigurationCallback(){

            @Override
            public PriorityConfigurationCallback setPrioritySelection(int priority, int jobGroupId, PriorityStrategy reason) {
                return this;
            }

            @Override
            public PriorityConfigurationCallback setPrioritySelection(int priority) {
                return this;
            }

            @Override
            public PriorityConfigurationCallback addDecisionLog(int indent, String log) {
                return this;
            }

            @Override
            public PriorityConfigurationCallback setPrioritySelection(int priority, long sortAsInQueueSince, int jobGroupId, PriorityStrategy reason) {
                return this;
            }
        };

        public String getDisplayName() {
            return Messages.AdvancedQueueSorterJobProperty_displayName();
        }

        public int getDefault() {
            return PrioritySorterConfiguration.get().getStrategy().getDefaultPriority();
        }

        public ListBoxModel getPriorities() {
            ListBoxModel items = PrioritySorterConfiguration.get().doGetPriorityItems();
            return items;
        }

        public boolean isUsed(Job<?, ?> owner) {
            PriorityConfiguration configuration = PriorityConfiguration.get();
            JobGroup jobGroup = configuration.getJobGroup(this.dummyCallback, owner);
            if (jobGroup != null && jobGroup.isUsePriorityStrategies()) {
                List<JobGroup.PriorityStrategyHolder> priorityStrategies = jobGroup.getPriorityStrategies();
                for (JobGroup.PriorityStrategyHolder priorityStrategyHolder : priorityStrategies) {
                    if (!(priorityStrategyHolder.getPriorityStrategy() instanceof JobPropertyStrategy)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

