/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.priority.strategy;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.priority.strategy.AbstractStaticPriorityStrategy;
import org.kohsuke.stapler.DataBoundConstructor;

public class HealthStrategy
extends AbstractStaticPriorityStrategy {
    private String selection;
    private String health;

    @DataBoundConstructor
    public HealthStrategy(int priority, String selection, String health) {
        this.setPriority(priority);
        this.selection = selection;
        this.health = health;
    }

    public String getSelection() {
        return this.selection;
    }

    public String getHealth() {
        return this.health;
    }

    @Override
    public boolean isApplicable(Queue.Item item) {
        Job job = (Job)item.task;
        if (!job.getBuilds().iterator().hasNext()) {
            return false;
        }
        int score = job.getBuildHealth().getScore();
        int scoreOver = 0;
        int scoreUnder = 100;
        if ("HEALTH_OVER_80".equals(this.health)) {
            scoreOver = 80;
            scoreUnder = 100;
        } else if ("HEALTH_61_TO_80".equals(this.health)) {
            scoreOver = 61;
            scoreUnder = 80;
        } else if ("HEALTH_41_TO_60".equals(this.health)) {
            scoreOver = 41;
            scoreUnder = 60;
        } else if ("HEALTH_21_TO_40".equals(this.health)) {
            scoreOver = 21;
            scoreUnder = 40;
        } else if ("HEALTH_0_TO_20".equals(this.health)) {
            scoreOver = 0;
            scoreUnder = 20;
        }
        if ("SAME".equals(this.selection)) {
            return score >= scoreOver && score <= scoreUnder;
        }
        if ("BETTER".equals(this.selection)) {
            return score >= scoreOver;
        }
        if ("WORSE".equals(this.selection)) {
            return score <= scoreUnder;
        }
        return false;
    }

    @Extension
    public static class HealthStrategyDescriptor
    extends AbstractStaticPriorityStrategy.AbstractStaticPriorityStrategyDescriptor {
        public HealthStrategyDescriptor() {
            super(Messages.Using_the_jobs_health());
        }
    }
}

