/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.jobinclusion.strategy;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.advancedqueue.DecisionLogger;
import jenkins.advancedqueue.jobinclusion.JobInclusionStrategy;
import jenkins.advancedqueue.jobinclusion.strategy.Messages;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ViewBasedJobInclusionStrategy
extends JobInclusionStrategy {
    private static final Logger LOGGER = Logger.getLogger(ViewBasedJobInclusionStrategy.class.getName());
    private String viewName;
    private boolean useJobFilter = false;
    private String jobPattern = ".*";

    @DataBoundConstructor
    public ViewBasedJobInclusionStrategy(String viewName) {
        this.viewName = viewName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public boolean isUseJobFilter() {
        return this.useJobFilter;
    }

    public String getJobPattern() {
        return this.jobPattern;
    }

    @DataBoundSetter
    public void setJobFilter(JobPattern jobFilter) {
        boolean bl = this.useJobFilter = jobFilter != null;
        if (this.useJobFilter) {
            if (jobFilter != null) {
                this.jobPattern = jobFilter.jobPattern;
            } else {
                LOGGER.log(Level.SEVERE, "Ignoring null job filter for view ''{0}''", this.viewName);
            }
        }
    }

    @DataBoundSetter
    public void setUseJobFilter(boolean useJobFilter) {
        this.useJobFilter = useJobFilter;
    }

    @DataBoundSetter
    public void setJobPattern(String jobPattern) {
        this.jobPattern = jobPattern;
    }

    private View getView() {
        String[] nestedViewNames = this.viewName.split("/");
        Jenkins jenkins = Jenkins.get();
        View view = jenkins.getView(nestedViewNames[0]);
        if (null == view) {
            LOGGER.log(Level.SEVERE, "Configured View does not exist ''{0}'' using primary view", this.viewName);
            return jenkins.getPrimaryView();
        }
        for (int i = 1; i < nestedViewNames.length; ++i) {
            if (!(view instanceof ViewGroup)) {
                LOGGER.log(Level.SEVERE, "View is not a ViewGroup ''{0}'', using primary view", this.viewName);
                return jenkins.getPrimaryView();
            }
            if (null != (view = ((ViewGroup)view).getView(nestedViewNames[i]))) continue;
            LOGGER.log(Level.SEVERE, "Configured View does not exist ''{0}'' using primary view", this.viewName);
            return jenkins.getPrimaryView();
        }
        return view;
    }

    @Override
    public boolean contains(DecisionLogger decisionLogger, Job<?, ?> job) {
        if (this.isJobInView(job, this.getView())) {
            if (!this.isUseJobFilter() || this.getJobPattern().trim().isEmpty()) {
                decisionLogger.addDecisionLog(2, "Not using filter ...");
                return true;
            }
            decisionLogger.addDecisionLog(2, "Using filter ...");
            try {
                if (job.getName().matches(this.getJobPattern())) {
                    decisionLogger.addDecisionLog(3, "Job is matching the filter ...");
                    return true;
                }
                decisionLogger.addDecisionLog(3, "Job is not matching the filter ...");
                return false;
            }
            catch (PatternSyntaxException e) {
                decisionLogger.addDecisionLog(3, "Filter has syntax error");
                return false;
            }
        }
        return false;
    }

    private boolean isJobInView(Job<?, ?> job, View view) {
        if (view.contains((TopLevelItem)job)) {
            return true;
        }
        if (view.getItems().contains(job)) {
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            return this.isJobInViewGroup(job, group);
        }
        return false;
    }

    private boolean isJobInViewGroup(Job<?, ?> job, ViewGroup viewGroup) {
        Collection views = viewGroup.getViews();
        for (View view : views) {
            if (!this.isJobInView(job, view)) continue;
            return true;
        }
        return false;
    }

    public static class JobPattern {
        private String jobPattern;

        @DataBoundConstructor
        public JobPattern(String jobPattern) {
            this.jobPattern = jobPattern;
        }
    }

    @Extension
    public static class ViewBasedJobInclusionStrategyDescriptor
    extends JobInclusionStrategy.AbstractJobInclusionStrategyDescriptor<ViewBasedJobInclusionStrategy> {
        public ViewBasedJobInclusionStrategyDescriptor() {
            super(Messages.Jobs_included_in_a_view());
        }

        public ListBoxModel getListViewItems() {
            ListBoxModel items = new ListBoxModel();
            Collection views = Jenkins.get().getViews();
            this.addViews("", items, views);
            return items;
        }

        private void addViews(String parent, ListBoxModel items, Collection<View> views) {
            for (View view : views) {
                items.add(parent + view.getDisplayName(), parent + view.getViewName());
                if (!(view instanceof ViewGroup)) continue;
                ViewGroup group = (ViewGroup)view;
                this.addViews(parent + view.getDisplayName() + "/", items, group.getViews());
            }
        }

        public FormValidation doCheckJobPattern(@QueryParameter String jobPattern) {
            if (jobPattern.isEmpty()) {
                return FormValidation.ok((String)Messages.Empty_pattern_matches_all_jobs());
            }
            try {
                Pattern.compile(jobPattern);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)exception.getDescription());
            }
            return FormValidation.ok((String)Messages.Pattern_is_valid());
        }
    }
}

