/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue;

import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.advancedqueue.JobGroup;
import jenkins.advancedqueue.PriorityConfiguration;
import jenkins.advancedqueue.PriorityConfigurationCallback;
import jenkins.advancedqueue.priority.PriorityStrategy;
import jenkins.advancedqueue.sorter.ItemInfo;
import jenkins.advancedqueue.sorter.QueueItemCache;

public class RunExclusiveThrottler {
    private static final List<String> exclusiveJobs = Collections.synchronizedList(new ArrayList());
    private static int exclusiveJobGroupId = -1;
    private static String exclusiveJobName = "";
    static PriorityConfigurationCallback dummyCallback = new PriorityConfigurationCallback(){

        @Override
        public PriorityConfigurationCallback setPrioritySelection(int priority, int jobGroupId, PriorityStrategy reason) {
            return this;
        }

        @Override
        public PriorityConfigurationCallback setPrioritySelection(int priority) {
            return this;
        }

        @Override
        public PriorityConfigurationCallback addDecisionLog(int indent, String log) {
            return this;
        }

        @Override
        public PriorityConfigurationCallback setPrioritySelection(int priority, long sortAsInQueueSince, int jobGroupId, PriorityStrategy reason) {
            return this;
        }
    };

    @Extension
    public static class RunExclusiveDispatcher
    extends QueueTaskDispatcher {
        public CauseOfBlockage canRun(Queue.Item item) {
            ItemInfo info;
            if (exclusiveJobs.size() > 0 && ((info = QueueItemCache.get().getItem(item.getId())) == null || info.getJobGroupId() != exclusiveJobGroupId)) {
                return new RunExclusiveMode();
            }
            return null;
        }
    }

    private static class RunExclusiveMode
    extends CauseOfBlockage {
        private RunExclusiveMode() {
        }

        public String getShortDescription() {
            return "Run Exclusive (" + exclusiveJobName + ")";
        }
    }

    @Extension
    public static class RunExclusiveRunListener
    extends RunListener<Run> {
        public void onStarted(Run r, TaskListener listener) {
            JobGroup jobGroup = PriorityConfiguration.get().getJobGroup(dummyCallback, r.getParent());
            if (jobGroup != null && jobGroup.isRunExclusive()) {
                exclusiveJobGroupId = jobGroup.getId();
                exclusiveJobName = r.getParent().getName();
                exclusiveJobs.add(exclusiveJobName);
            }
        }

        public void onCompleted(Run r, TaskListener listener) {
            exclusiveJobs.remove(r.getParent().getName());
        }
    }
}

