/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue;

import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Job;
import jenkins.advancedqueue.PriorityConfigurationCallback;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.sorter.ItemInfo;
import jenkins.advancedqueue.sorter.QueueItemCache;

class PriorityConfigurationMatrixHelper {
    PriorityConfigurationMatrixHelper() {
    }

    boolean isMatrixConfiguration(Job<?, ?> job) {
        return job instanceof MatrixConfiguration;
    }

    PriorityConfigurationCallback getPriority(MatrixConfiguration matrixConfiguration, PriorityConfigurationCallback priorityCallback) {
        MatrixProject matrixProject = matrixConfiguration.getParent();
        priorityCallback.addDecisionLog(0, "Job is MatrixConfiguration [" + matrixProject.getName() + "] ...");
        ItemInfo itemInfo = QueueItemCache.get().getItem(matrixProject.getName());
        if (itemInfo != null) {
            priorityCallback.addDecisionLog(0, "MatrixProject found in cache, using priority from queue-item [" + itemInfo.getItemId() + "]");
            return priorityCallback.setPrioritySelection(itemInfo.getPriority(), itemInfo.getJobGroupId(), itemInfo.getPriorityStrategy());
        }
        priorityCallback.addDecisionLog(0, "MatrixProject not found in cache, assigning global default priority");
        return priorityCallback.setPrioritySelection(PrioritySorterConfiguration.get().getStrategy().getDefaultPriority());
    }
}

