/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter.strategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Queue;
import java.util.HashMap;
import java.util.Map;
import jenkins.advancedqueue.sorter.SorterStrategyCallback;
import jenkins.advancedqueue.sorter.strategy.MultiBucketStrategy;

public abstract class FQBaseStrategy
extends MultiBucketStrategy {
    protected static final float MIN_STEP_SIZE = 1.0E-5f;
    static final Map<Integer, Float> prio2weight = new HashMap<Integer, Float>();
    private static final float MIN_STARTED_WEIGHT = 1.0f;
    static float maxStartedWeight = 1.0f;

    public FQBaseStrategy() {
    }

    public FQBaseStrategy(int numberOfPriorities, int defaultPriority) {
        super(numberOfPriorities, defaultPriority);
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void onStartedItem(Queue.LeftItem item, float weight) {
        maxStartedWeight = Math.max(maxStartedWeight, weight);
    }

    @Override
    public SorterStrategyCallback onNewItem(Queue.Item item, SorterStrategyCallback weightCallback) {
        int priority = weightCallback.getPriority();
        float minimumWeightToAssign = this.getMinimumWeightToAssign(priority);
        float weightToUse = this.getWeightToUse(priority, minimumWeightToAssign);
        prio2weight.put(priority, Float.valueOf(weightToUse));
        return weightCallback.setWeightSelection(weightToUse);
    }

    protected float getMinimumWeightToAssign(int priority) {
        Float minWeight = prio2weight.get(priority);
        if (minWeight == null) {
            return maxStartedWeight;
        }
        return Math.max(maxStartedWeight, minWeight.floatValue());
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    protected float getWeightToUse(int priority, float minimumWeightToAssign) {
        float weight = minimumWeightToAssign * (1.0f + this.getStepSize(priority));
        if (Float.POSITIVE_INFINITY == weight) {
            maxStartedWeight = 1.0f;
            prio2weight.clear();
            return 1.0f;
        }
        return weight;
    }

    abstract float getStepSize(int var1);
}

