/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.WorkUnit;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import jenkins.advancedqueue.sorter.ItemInfo;

public class StartedJobItemCache {
    private static final int RETENTION_COUNT = 10000;
    private static final int RETENTION_TIME_HOURS = 12;
    private static StartedJobItemCache startedJobItemCache = null;
    private final LinkedList<PendingItem> pendingItems = new LinkedList();
    private final Cache<StartedItem, ItemInfo> startedItems = CacheBuilder.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(10000L).build();

    public static StartedJobItemCache get() {
        return startedJobItemCache;
    }

    private StartedJobItemCache() {
    }

    @CheckForNull
    public synchronized ItemInfo getStartedItem(String projectName, int buildNumber) {
        this.maintainCache();
        return (ItemInfo)this.startedItems.getIfPresent((Object)new StartedItem(projectName, buildNumber));
    }

    public synchronized void addItem(ItemInfo itemInfo, WorkUnit primaryWorkUnit) {
        this.pendingItems.addLast(new PendingItem(itemInfo, primaryWorkUnit));
        this.maintainCache();
    }

    private void maintainCache() {
        PendingItem pi;
        Iterator it = this.pendingItems.iterator();
        while (it.hasNext()) {
            pi = (PendingItem)it.next();
            Queue.Executable e = pi.workUnit.getExecutable();
            if (!(e instanceof Run)) continue;
            Run run = (Run)e;
            this.startedItems.put((Object)new StartedItem(pi.itemInfo.getJobName(), run.getNumber()), (Object)pi.itemInfo);
            it.remove();
        }
        if (this.pendingItems.size() > 10000) {
            this.pendingItems.subList(0, this.pendingItems.size() - 10000).clear();
        }
        it = this.pendingItems.iterator();
        while (it.hasNext()) {
            pi = (PendingItem)it.next();
            if (pi.startTime >= System.currentTimeMillis() - 43200000L) break;
            it.remove();
        }
    }

    static {
        startedJobItemCache = new StartedJobItemCache();
    }

    private static class StartedItem {
        final String projectName;
        final int buildNumber;

        public StartedItem(String projectName, int buildNumber) {
            this.projectName = projectName;
            this.buildNumber = buildNumber;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.projectName, this.buildNumber});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StartedItem other = (StartedItem)obj;
            return Objects.equal((Object)this.projectName, (Object)other.projectName) && this.buildNumber == other.buildNumber;
        }
    }

    private static class PendingItem {
        final long startTime = System.currentTimeMillis();
        final ItemInfo itemInfo;
        final WorkUnit workUnit;

        public PendingItem(ItemInfo itemInfo, WorkUnit workUnit) {
            this.itemInfo = itemInfo;
            this.workUnit = workUnit;
        }
    }
}

