/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Queue;
import java.util.ArrayList;
import java.util.List;
import jenkins.advancedqueue.sorter.SorterStrategyCallback;
import jenkins.advancedqueue.sorter.SorterStrategyDescriptor;
import jenkins.model.Jenkins;

public abstract class SorterStrategy
implements ExtensionPoint,
Describable<SorterStrategy> {
    public SorterStrategyDescriptor getDescriptor() {
        return (SorterStrategyDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public abstract SorterStrategyCallback onNewItem(@NonNull Queue.Item var1, SorterStrategyCallback var2);

    public void onStartedItem(@NonNull Queue.LeftItem item, float weight) {
    }

    public void onCanceledItem(@NonNull Queue.LeftItem item) {
    }

    public abstract int getNumberOfPriorities();

    public abstract int getDefaultPriority();

    public static List<SorterStrategyDescriptor> getAllSorterStrategies() {
        ExtensionList<SorterStrategy> all = SorterStrategy.all();
        ArrayList<SorterStrategyDescriptor> strategies = new ArrayList<SorterStrategyDescriptor>(all.size());
        for (SorterStrategy prioritySorterStrategy : all) {
            strategies.add(prioritySorterStrategy.getDescriptor());
        }
        return strategies;
    }

    @CheckForNull
    public static SorterStrategyDescriptor getSorterStrategy(String key) {
        List<SorterStrategyDescriptor> allSorterStrategies = SorterStrategy.getAllSorterStrategies();
        for (SorterStrategyDescriptor sorterStrategy : allSorterStrategies) {
            if (!key.equals(sorterStrategy.getKey())) continue;
            return sorterStrategy;
        }
        return null;
    }

    @CheckForNull
    public static SorterStrategy getPrioritySorterStrategy(SorterStrategyDescriptor sorterStrategy) {
        ExtensionList<SorterStrategy> all = SorterStrategy.all();
        for (SorterStrategy prioritySorterStrategy : all) {
            if (!prioritySorterStrategy.getDescriptor().getKey().equals(sorterStrategy.getKey())) continue;
            return prioritySorterStrategy;
        }
        return null;
    }

    public static ExtensionList<SorterStrategy> all() {
        return Jenkins.get().getExtensionList(SorterStrategy.class);
    }
}

