/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.advancedqueue.sorter.ItemInfo;

public class QueueItemCache {
    private static final Logger LOGGER = Logger.getLogger(QueueItemCache.class.getName());
    private static QueueItemCache queueItemCache = null;
    private Map<Long, ItemInfo> item2info = new HashMap<Long, ItemInfo>();
    private Map<String, ItemInfo> jobName2info = new HashMap<String, ItemInfo>();

    public static QueueItemCache get() {
        return queueItemCache;
    }

    private QueueItemCache() {
    }

    public synchronized ItemInfo getItem(long itemId) {
        return this.item2info.get(itemId);
    }

    @Deprecated
    public synchronized ItemInfo getItem(Integer itemId) {
        return this.item2info.get(itemId.longValue());
    }

    @CheckForNull
    public synchronized ItemInfo getItem(String jobName) {
        return this.jobName2info.get(jobName);
    }

    public synchronized ItemInfo addItem(ItemInfo itemInfo) {
        long itemId = itemInfo.getItemId();
        this.item2info.put(itemId, itemInfo);
        this.jobName2info.put(itemInfo.getJobName(), itemInfo);
        return itemInfo;
    }

    @Deprecated
    @CheckForNull
    public synchronized ItemInfo removeItem(Integer itemId) {
        return this.item2info.remove(itemId.longValue());
    }

    @CheckForNull
    public synchronized ItemInfo removeItem(long itemId) {
        return this.item2info.remove(itemId);
    }

    public synchronized List<ItemInfo> getSortedList() {
        ArrayList<ItemInfo> list = new ArrayList<ItemInfo>(this.item2info.values());
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }

    static {
        queueItemCache = new QueueItemCache();
    }
}

