/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.sorter;

import hudson.Extension;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import java.util.logging.Logger;
import jenkins.advancedqueue.sorter.AdvancedQueueSorter;
import jenkins.advancedqueue.sorter.ItemInfo;
import jenkins.advancedqueue.sorter.QueueItemCache;

@Extension
public class AdvancedQueueSorterQueueListener
extends QueueListener {
    private static final Logger LOGGER = Logger.getLogger(AdvancedQueueSorterQueueListener.class.getName());

    public void onEnterWaiting(Queue.WaitingItem wi) {
        AdvancedQueueSorter.get().onNewItem((Queue.Item)wi);
    }

    public void onLeft(Queue.LeftItem li) {
        AdvancedQueueSorter.get().onLeft(li);
    }

    public void onEnterBuildable(Queue.BuildableItem bi) {
        ItemInfo item = QueueItemCache.get().getItem(bi.getId());
        if (item == null) {
            LOGGER.warning("onEnterBuilding() called without prior call to onEnterWaiting() for '" + bi.task.getDisplayName() + "'");
            AdvancedQueueSorter.get().onNewItem((Queue.Item)bi);
        }
        QueueItemCache.get().getItem(bi.getId()).setBuildable();
    }

    public void onEnterBlocked(Queue.BlockedItem bi) {
        ItemInfo item = QueueItemCache.get().getItem(bi.getId());
        if (item == null) {
            LOGGER.warning("onEnterBlocked() called without prior call to onEnterWaiting() for '" + bi.task.getDisplayName() + "'");
            AdvancedQueueSorter.get().onNewItem((Queue.Item)bi);
        }
        QueueItemCache.get().getItem(bi.getId()).setBlocked();
    }
}

