/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.priority.strategy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Queue;
import java.util.List;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.priority.strategy.AbstractDynamicPriorityStrategy;
import jenkins.advancedqueue.sorter.ItemInfo;
import jenkins.advancedqueue.sorter.StartedJobItemCache;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamCauseStrategy
extends AbstractDynamicPriorityStrategy {
    @DataBoundConstructor
    public UpstreamCauseStrategy() {
    }

    @CheckForNull
    private Cause.UpstreamCause getUpstreamCause(@NonNull Queue.Item item) {
        List causes = item.getCauses();
        for (Cause cause : causes) {
            if (cause.getClass() != Cause.UpstreamCause.class) continue;
            return (Cause.UpstreamCause)cause;
        }
        return null;
    }

    @Override
    public int getPriority(Queue.Item item) {
        Cause.UpstreamCause upstreamCause = this.getUpstreamCause(item);
        if (upstreamCause == null) {
            return PrioritySorterConfiguration.get().getStrategy().getDefaultPriority();
        }
        String upstreamProject = upstreamCause.getUpstreamProject();
        int upstreamBuildId = upstreamCause.getUpstreamBuild();
        ItemInfo upstreamItem = StartedJobItemCache.get().getStartedItem(upstreamProject, upstreamBuildId);
        if (upstreamItem != null) {
            return upstreamItem.getPriority();
        }
        return PrioritySorterConfiguration.get().getStrategy().getDefaultPriority();
    }

    @Override
    public boolean isApplicable(Queue.Item item) {
        return this.getUpstreamCause(item) != null;
    }

    @Extension
    public static class BuildParameterStrategyDescriptor
    extends AbstractDynamicPriorityStrategy.AbstractDynamicPriorityStrategyDescriptor {
        public BuildParameterStrategyDescriptor() {
            super(Messages.Job_triggered_by_a_upstream_build());
        }
    }
}

