/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.priority.strategy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.priority.strategy.AbstractDynamicPriorityStrategy;
import jenkins.advancedqueue.priority.strategy.PriorityJobProperty;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobPropertyStrategy
extends AbstractDynamicPriorityStrategy {
    @DataBoundConstructor
    public JobPropertyStrategy() {
    }

    @CheckForNull
    private Integer getPriorityInternal(Queue.Item item) {
        Job job;
        PriorityJobProperty priorityProperty;
        Queue.Task task;
        if (item != null && (task = item.task) instanceof Job && (priorityProperty = (PriorityJobProperty)(job = (Job)task).getProperty(PriorityJobProperty.class)) != null && priorityProperty.getUseJobPriority()) {
            return priorityProperty.priority;
        }
        return null;
    }

    @Override
    public boolean isApplicable(Queue.Item item) {
        return this.getPriorityInternal(item) != null;
    }

    @Override
    public int getPriority(Queue.Item item) {
        Integer p = this.getPriorityInternal(item);
        return p != null ? p.intValue() : PrioritySorterConfiguration.get().getStrategy().getDefaultPriority();
    }

    @Extension
    public static class UserIdCauseStrategyDescriptor
    extends AbstractDynamicPriorityStrategy.AbstractDynamicPriorityStrategyDescriptor {
        public UserIdCauseStrategyDescriptor() {
            super(Messages.Take_the_priority_from_property_on_the_job());
        }
    }
}

