/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.priority.strategy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.StringParameterValue;
import java.util.List;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.priority.strategy.AbstractDynamicPriorityStrategy;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildParameterStrategy
extends AbstractDynamicPriorityStrategy {
    private final String parameterName;

    @DataBoundConstructor
    public BuildParameterStrategy(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @CheckForNull
    private Integer getPriorityInternal(@NonNull Queue.Item item) {
        List actions = item.getActions(ParametersAction.class);
        for (ParametersAction action : actions) {
            String value;
            StringParameterValue parameterValue = (StringParameterValue)action.getParameter(this.parameterName);
            if (parameterValue == null || (value = parameterValue.getValue()) == null) continue;
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }

    @Override
    public int getPriority(@NonNull Queue.Item item) {
        Integer p = this.getPriorityInternal(item);
        return p != null ? p.intValue() : PrioritySorterConfiguration.get().getStrategy().getDefaultPriority();
    }

    @Override
    public boolean isApplicable(@NonNull Queue.Item item) {
        return this.getPriorityInternal(item) != null;
    }

    @Extension
    public static class BuildParameterStrategyDescriptor
    extends AbstractDynamicPriorityStrategy.AbstractDynamicPriorityStrategyDescriptor {
        public BuildParameterStrategyDescriptor() {
            super(Messages.Use_Priority_from_Build_Parameter());
        }
    }
}

