/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.priority.strategy;

import hudson.model.Descriptor;
import hudson.model.Queue;
import hudson.util.ListBoxModel;
import jenkins.advancedqueue.PriorityCalculationsUtil;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.priority.PriorityStrategy;
import jenkins.model.Jenkins;

public abstract class AbstractStaticPriorityStrategy
extends PriorityStrategy {
    private int priority;

    public Descriptor<PriorityStrategy> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @Override
    public void numberPrioritiesUpdates(int oldNumberOfPriorities, int newNumberOfPriorities) {
        this.priority = PriorityCalculationsUtil.scale(oldNumberOfPriorities, newNumberOfPriorities, this.priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority(Queue.Item item) {
        return this.priority;
    }

    public static class AbstractStaticPriorityStrategyDescriptor
    extends Descriptor<PriorityStrategy> {
        private final String displayName;

        protected AbstractStaticPriorityStrategyDescriptor(String displayName) {
            this.displayName = displayName;
        }

        public ListBoxModel getPriorities() {
            ListBoxModel items = PrioritySorterConfiguration.get().doGetPriorityItems();
            return items;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

