/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.jobrestrictions;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import java.util.logging.Logger;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.sorter.ItemInfo;
import jenkins.advancedqueue.sorter.QueueItemCache;
import jenkins.advancedqueue.util.PrioritySorterUtil;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Common usage in Jenkins to not include SE_NO_SERIALVERSIONID")
public class PrioritySorterRestriction
extends JobRestriction {
    private static final Logger LOGGER = Logger.getLogger(PrioritySorterRestriction.class.getName());
    private int fromPriority;
    private int toPriority;

    public int getFromPriority() {
        return this.fromPriority;
    }

    public int getToPriority() {
        return this.toPriority;
    }

    @DataBoundConstructor
    public PrioritySorterRestriction(int fromPriority, int toPriority) {
        this.fromPriority = fromPriority;
        this.toPriority = toPriority;
    }

    public boolean canTake(Queue.BuildableItem buildableItem) {
        ItemInfo item = QueueItemCache.get().getItem(buildableItem.getId());
        if (item == null) {
            LOGGER.warning("Missing ItemInfo for [" + buildableItem.task.getDisplayName() + "] allowing execution.");
            return true;
        }
        int priority = item.getPriority();
        return priority >= this.fromPriority && priority <= this.toPriority;
    }

    public boolean canTake(Run run) {
        return true;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.Priority_from_prioritySorter();
        }

        public ListBoxModel doFillFromPriorityItems() {
            return PrioritySorterUtil.fillPriorityItems(PrioritySorterConfiguration.get().getStrategy().getNumberOfPriorities());
        }

        public ListBoxModel doFillToPriorityItems() {
            return PrioritySorterUtil.fillPriorityItems(PrioritySorterConfiguration.get().getStrategy().getNumberOfPriorities());
        }

        public ListBoxModel doUpdateFromPriorityItems(@QueryParameter(value="value") String strValue) {
            int value = 1;
            try {
                value = Integer.parseInt(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return PrioritySorterUtil.fillPriorityItems(value, PrioritySorterConfiguration.get().getStrategy().getNumberOfPriorities());
        }
    }
}

