/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.jobinclusion.strategy;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.advancedqueue.DecisionLogger;
import jenkins.advancedqueue.JobGroup;
import jenkins.advancedqueue.PriorityConfiguration;
import jenkins.advancedqueue.jobinclusion.JobInclusionStrategy;
import jenkins.advancedqueue.jobinclusion.strategy.FolderPropertyLoader;
import jenkins.advancedqueue.jobinclusion.strategy.JobInclusionJobProperty;
import jenkins.advancedqueue.jobinclusion.strategy.Messages;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class PropertyBasedJobInclusionStrategy
extends JobInclusionStrategy {
    private String name;

    PropertyBasedJobInclusionStrategyDescriptor getThisDescriptor() {
        return (PropertyBasedJobInclusionStrategyDescriptor)super.getDescriptor();
    }

    @DataBoundConstructor
    public PropertyBasedJobInclusionStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean contains(DecisionLogger decisionLogger, Job<?, ?> job) {
        JobInclusionJobProperty property = (JobInclusionJobProperty)job.getProperty(JobInclusionJobProperty.class);
        decisionLogger.addDecisionLog(2, "Checking for Job Property inclusion for [" + this.name + "]...");
        if (property != null && property.isUseJobGroup()) {
            decisionLogger.addDecisionLog(3, "JobGroup is enabled on job, with JobGroup [" + property.getJobGroupName() + "] ...");
            boolean match = this.name.equals(property.getJobGroupName());
            if (match) {
                decisionLogger.addDecisionLog(3, "Job is included in JobGroup ...");
            } else {
                decisionLogger.addDecisionLog(3, "Job is not included in JobGroup ...");
            }
            return match;
        }
        if (((PropertyBasedJobInclusionStrategyDescriptor)this.getDescriptor()).cloudbeesFolders) {
            String jobViewName = FolderPropertyLoader.getJobGroupName(decisionLogger, job);
            if (jobViewName == null) {
                return false;
            }
            boolean match = this.name.equals(jobViewName);
            if (match) {
                decisionLogger.addDecisionLog(4, "Job is included in JobGroup ...");
            } else {
                decisionLogger.addDecisionLog(4, "Job is not included in JobGroup ...");
            }
            return match;
        }
        return false;
    }

    public static ListBoxModel getPropertyBasesJobGroups() {
        List<JobGroup> jobGroups = PriorityConfiguration.get().getJobGroups();
        ListBoxModel strategies = new ListBoxModel();
        for (JobGroup jobGroup : jobGroups) {
            JobInclusionStrategy inclusionStrategy = jobGroup.getJobGroupStrategy();
            if (!(inclusionStrategy instanceof PropertyBasedJobInclusionStrategy)) continue;
            PropertyBasedJobInclusionStrategy strategy = (PropertyBasedJobInclusionStrategy)inclusionStrategy;
            strategies.add(strategy.getName());
        }
        return strategies;
    }

    @Extension
    public static class PropertyBasedJobInclusionStrategyDescriptor
    extends Descriptor<JobInclusionStrategy> {
        boolean cloudbeesFolders = true;

        public String getDisplayName() {
            if (this.cloudbeesFolders) {
                return Messages.Jobs_and_Folders_marked_for_inclusion();
            }
            return Messages.Jobs_marked_for_inclusion();
        }

        public PropertyBasedJobInclusionStrategyDescriptor() {
            Plugin plugin = Jenkins.get().getPlugin("cloudbees-folder");
            if (plugin == null || !plugin.getWrapper().isEnabled()) {
                this.cloudbeesFolders = false;
            }
        }
    }
}

