/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.jobinclusion.strategy;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.util.DescribableList;
import jenkins.advancedqueue.DecisionLogger;
import jenkins.advancedqueue.jobinclusion.strategy.JobInclusionFolderProperty;

public class FolderPropertyLoader {
    @CheckForNull
    public static String getJobGroupName(DecisionLogger decisionLogger, Job<?, ?> job) {
        ItemGroup parent = job.getParent();
        decisionLogger.addDecisionLog(2, "Checking for Cloudbees Folder inclusion ...");
        while (parent != null) {
            if (parent instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)parent;
                decisionLogger.addDecisionLog(3, "Evaluating Folder [" + folder.getFullName() + "] ...");
                DescribableList properties = folder.getProperties();
                for (AbstractFolderProperty property : properties) {
                    JobInclusionFolderProperty incProperty;
                    if (!(property instanceof JobInclusionFolderProperty) || !(incProperty = (JobInclusionFolderProperty)property).isUseJobGroup()) continue;
                    String name = incProperty.getJobGroupName();
                    decisionLogger.addDecisionLog(4, "JobGroup is enabled, with JobGroup [" + name + "] ...");
                    return name;
                }
            }
            if (parent instanceof TopLevelItem) {
                TopLevelItem item = (TopLevelItem)parent;
                parent = item.getParent();
                continue;
            }
            parent = null;
        }
        decisionLogger.addDecisionLog(2, "No match ...");
        return null;
    }
}

