/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue.jobinclusion.strategy;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.Job;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.advancedqueue.DecisionLogger;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.jobinclusion.JobInclusionStrategy;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class FolderBasedJobInclusionStrategy
extends JobInclusionStrategy {
    private String folderName;

    @DataBoundConstructor
    public FolderBasedJobInclusionStrategy(String folderName) {
        this.folderName = folderName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public boolean contains(DecisionLogger decisionLogger, Job<?, ?> job) {
        return job.getFullName().startsWith(this.folderName);
    }

    @Extension(optional=true)
    public static class FolderBasedJobInclusionStrategyDescriptor
    extends JobInclusionStrategy.AbstractJobInclusionStrategyDescriptor<FolderBasedJobInclusionStrategy> {
        public FolderBasedJobInclusionStrategyDescriptor() {
            super(Messages.Jobs_included_in_folder());
        }

        public ListBoxModel getListFolderItems() {
            ListBoxModel items = new ListBoxModel();
            List folders = Jenkins.get().getAllItems(Folder.class);
            for (Folder folder : folders) {
                items.add(folder.getFullName(), folder.getFullName());
            }
            return items;
        }
    }
}

