/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.advancedqueue.JobGroup;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PriorityCalculationsUtil;
import jenkins.advancedqueue.PriorityConfiguration;
import jenkins.advancedqueue.priority.strategy.PriorityJobProperty;
import jenkins.advancedqueue.sorter.SorterStrategy;
import jenkins.advancedqueue.sorter.SorterStrategyDescriptor;
import jenkins.advancedqueue.sorter.strategy.AbsoluteStrategy;
import jenkins.advancedqueue.util.PrioritySorterUtil;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class PrioritySorterConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(PrioritySorterConfiguration.class.getName());
    private static final SorterStrategy DEFAULT_STRATEGY = new AbsoluteStrategy(5, 3);
    @Deprecated
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="Allow deserialization of old definitions")
    private boolean allowPriorityOnJobs;
    private boolean onlyAdminsMayEditPriorityConfiguration = false;
    private SorterStrategy strategy = DEFAULT_STRATEGY;

    public static void init() {
        PrioritySorterConfiguration prioritySorterConfiguration = PrioritySorterConfiguration.get();
        prioritySorterConfiguration.strategy = DEFAULT_STRATEGY;
        prioritySorterConfiguration.allowPriorityOnJobs = false;
        prioritySorterConfiguration.load();
    }

    public boolean getOnlyAdminsMayEditPriorityConfiguration() {
        return this.onlyAdminsMayEditPriorityConfiguration;
    }

    public SorterStrategy getStrategy() {
        return this.strategy;
    }

    public ListBoxModel doFillStrategyItems() {
        ListBoxModel strategies = new ListBoxModel();
        List<SorterStrategyDescriptor> values = SorterStrategy.getAllSorterStrategies();
        for (SorterStrategyDescriptor sorterStrategy : values) {
            strategies.add(sorterStrategy.getDisplayName(), sorterStrategy.getKey());
        }
        return strategies;
    }

    public ListBoxModel doGetPriorityItems() {
        ListBoxModel items = PrioritySorterUtil.fillPriorityItems(this.strategy.getNumberOfPriorities());
        items.add(0, (Object)new ListBoxModel.Option(Messages.Use_default_priority(), String.valueOf(PriorityCalculationsUtil.getUseDefaultPriorityPriority())));
        return items;
    }

    public FormValidation doCheckNumberOfPriorities(@QueryParameter String value) {
        if (value.length() == 0) {
            return FormValidation.error((String)Messages.PrioritySorterConfiguration_enterValueRequestMessage());
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue <= 0) {
                return FormValidation.error((String)Messages.PrioritySorterConfiguration_enterValueRequestMessage());
            }
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.PrioritySorterConfiguration_enterValueRequestMessage());
        }
        return FormValidation.ok();
    }

    private void updatePriorities(int prevNumberOfPriorities) {
        try (ACLContext saveCtx = ACL.as((Authentication)ACL.SYSTEM);){
            List allJobs = Jenkins.get().getAllItems(Job.class);
            for (Job job : allJobs) {
                try {
                    int newPriority;
                    PriorityJobProperty priorityProperty = (PriorityJobProperty)job.getProperty(PriorityJobProperty.class);
                    if (priorityProperty == null || !priorityProperty.getUseJobPriority() || (newPriority = PriorityCalculationsUtil.scale(prevNumberOfPriorities, this.strategy.getNumberOfPriorities(), priorityProperty.priority)) == priorityProperty.getPriority()) continue;
                    job.removeProperty((JobProperty)priorityProperty);
                    job.addProperty((JobProperty)new PriorityJobProperty(priorityProperty.getUseJobPriority(), newPriority));
                    job.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to update Advanced Job Priority To {0}", job.getName());
                }
            }
            List<JobGroup> jobGroups = PriorityConfiguration.get().getJobGroups();
            for (JobGroup jobGroup : jobGroups) {
                jobGroup.setPriority(PriorityCalculationsUtil.scale(prevNumberOfPriorities, this.strategy.getNumberOfPriorities(), jobGroup.getPriority()));
                List<JobGroup.PriorityStrategyHolder> priorityStrategies = jobGroup.getPriorityStrategies();
                for (JobGroup.PriorityStrategyHolder priorityStrategyHolder : priorityStrategies) {
                    priorityStrategyHolder.getPriorityStrategy().numberPrioritiesUpdates(prevNumberOfPriorities, this.strategy.getNumberOfPriorities());
                }
            }
            PriorityConfiguration.get().save();
        }
    }

    @DataBoundSetter
    public void setOnlyAdminsMayEditPriorityConfiguration(boolean onlyAdminsMayEditPriorityConfiguration) {
        this.onlyAdminsMayEditPriorityConfiguration = onlyAdminsMayEditPriorityConfiguration;
        this.save();
    }

    @DataBoundSetter
    public void setStrategy(SorterStrategy strategy) {
        this.updatePriorities(strategy.getNumberOfPriorities());
        this.strategy = strategy;
        this.save();
    }

    public static PrioritySorterConfiguration get() {
        return (PrioritySorterConfiguration)((Object)GlobalConfiguration.all().get(PrioritySorterConfiguration.class));
    }
}

