/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.security.ACL;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.advancedqueue.JobGroup;
import jenkins.advancedqueue.Messages;
import jenkins.advancedqueue.PriorityCalculationsUtil;
import jenkins.advancedqueue.PriorityConfigurationCallback;
import jenkins.advancedqueue.PriorityConfigurationMatrixHelper;
import jenkins.advancedqueue.PriorityConfigurationPlaceholderTaskHelper;
import jenkins.advancedqueue.PrioritySorterConfiguration;
import jenkins.advancedqueue.jobinclusion.JobInclusionStrategy;
import jenkins.advancedqueue.priority.PriorityStrategy;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class PriorityConfiguration
extends GlobalConfiguration
implements RootAction,
IconSpec {
    private static final Logger LOGGER = Logger.getLogger(PriorityConfiguration.class.getName());
    private transient Map<Integer, JobGroup> id2jobGroup;
    private transient PriorityConfigurationMatrixHelper priorityConfigurationMatrixHelper;
    private transient PriorityConfigurationPlaceholderTaskHelper placeholderTaskHelper = new PriorityConfigurationPlaceholderTaskHelper();
    private List<JobGroup> jobGroups = new LinkedList<JobGroup>();

    public PriorityConfiguration() {
        this.load();
        Collections.sort(this.jobGroups, (o1, o2) -> o1.getId() - o2.getId());
        this.id2jobGroup = new HashMap<Integer, JobGroup>();
        for (JobGroup jobGroup : this.jobGroups) {
            this.id2jobGroup.put(jobGroup.getId(), jobGroup);
            Collections.sort(jobGroup.getPriorityStrategies(), (o1, o2) -> o1.getId() - o2.getId());
        }
        Plugin plugin = Jenkins.get().getPlugin("matrix-project");
        this.priorityConfigurationMatrixHelper = plugin == null || !plugin.getWrapper().isEnabled() ? null : new PriorityConfigurationMatrixHelper();
    }

    public String getIconFileName() {
        return null;
    }

    public String getIconClassName() {
        if (!this.checkActive()) {
            return null;
        }
        return "symbol-swap-vertical-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return Messages.PriorityConfiguration_displayName();
    }

    public String getUrlName() {
        if (!this.checkActive()) {
            return null;
        }
        return "advanced-build-queue";
    }

    private boolean checkActive() {
        PrioritySorterConfiguration configuration = PrioritySorterConfiguration.get();
        if (configuration.getOnlyAdminsMayEditPriorityConfiguration()) {
            return Jenkins.get().getACL().hasPermission(Jenkins.ADMINISTER);
        }
        return true;
    }

    public List<JobGroup> getJobGroups() {
        return this.jobGroups;
    }

    public void setJobGroups(List<JobGroup> jobGroups) {
        this.jobGroups = jobGroups;
        this.save();
    }

    public JobGroup getJobGroup(int id) {
        return this.id2jobGroup.get(id);
    }

    public ExtensionList<Descriptor<PriorityStrategy>> getPriorityStrategyDescriptors() {
        return PriorityStrategy.all();
    }

    public DescriptorExtensionList<JobInclusionStrategy, Descriptor<JobInclusionStrategy>> getJobInclusionStrategyDescriptors() {
        return JobInclusionStrategy.all();
    }

    public ListBoxModel getPriorities() {
        ListBoxModel items = PrioritySorterConfiguration.get().doGetPriorityItems();
        return items;
    }

    public void doPriorityConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Object object;
        JSONObject jobGroupObject;
        this.jobGroups = new LinkedList<JobGroup>();
        this.id2jobGroup = new HashMap<Integer, JobGroup>();
        String parameter = req.getParameter("json");
        JSONObject jobGroupsObject = JSONObject.fromObject((Object)parameter);
        JSONArray jsonArray = JSONArray.fromObject((Object)jobGroupsObject.get("jobGroup"));
        int id = 0;
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext() && !(jobGroupObject = JSONObject.fromObject(object = iterator.next())).isEmpty()) {
            jobGroupObject.element("id", id++);
            this.transformPriorityStrategiesData(jobGroupObject);
            JobGroup jobGroup = (JobGroup)req.bindJSON(JobGroup.class, jobGroupObject);
            this.jobGroups.add(jobGroup);
            this.id2jobGroup.put(jobGroup.getId(), jobGroup);
        }
        this.save();
        FormApply.success((String)"..").generateResponse(req, rsp, (Object)this);
    }

    public FormValidation doCheckJobPattern(@QueryParameter String value) throws IOException, ServletException {
        if (value.length() > 0) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                return FormValidation.warning((String)"The expression is not valid, please enter a valid expression.");
            }
        }
        return FormValidation.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriorityConfigurationCallback getPriority(Queue.Item item, PriorityConfigurationCallback priorityCallback) {
        SecurityContext saveCtx = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            PriorityConfigurationCallback priorityConfigurationCallback = this.getPriorityInternal(item, priorityCallback);
            return priorityConfigurationCallback;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)saveCtx);
        }
    }

    private void transformPriorityStrategiesData(JSONObject jobGroupObject) {
        if (jobGroupObject.has("usePriorityStrategies")) {
            JSONObject usePriorityStrategies = jobGroupObject.getJSONObject("usePriorityStrategies");
            if (usePriorityStrategies.has("holder")) {
                JSONArray priorityStrategies = JSONArray.fromObject((Object)usePriorityStrategies.get("holder"));
                jobGroupObject.element("priorityStrategies", (Collection)priorityStrategies);
                jobGroupObject.element("usePriorityStrategies", true);
            } else {
                jobGroupObject.element("usePriorityStrategies", false);
            }
        }
    }

    private PriorityConfigurationCallback getPriorityInternal(Queue.Item item, PriorityConfigurationCallback priorityCallback) {
        if (this.placeholderTaskHelper.isPlaceholderTask(item.task)) {
            return this.placeholderTaskHelper.getPriority((ExecutorStepExecution.PlaceholderTask)item.task, priorityCallback);
        }
        if (!(item.task instanceof Job)) {
            priorityCallback.addDecisionLog(0, "Queue.Item is not a Job - Assigning global default priority");
            return priorityCallback.setPrioritySelection(PrioritySorterConfiguration.get().getStrategy().getDefaultPriority());
        }
        Job job = (Job)item.task;
        if (this.priorityConfigurationMatrixHelper != null && this.priorityConfigurationMatrixHelper.isMatrixConfiguration(job)) {
            return this.priorityConfigurationMatrixHelper.getPriority((MatrixConfiguration)job, priorityCallback);
        }
        JobGroup jobGroup = this.getJobGroup(priorityCallback, job);
        if (jobGroup != null) {
            return this.getPriorityForJobGroup(priorityCallback, jobGroup, item);
        }
        priorityCallback.addDecisionLog(0, "Assigning global default priority");
        return priorityCallback.setPrioritySelection(PrioritySorterConfiguration.get().getStrategy().getDefaultPriority());
    }

    @CheckForNull
    public JobGroup getJobGroup(@NonNull PriorityConfigurationCallback priorityCallback, @NonNull Job<?, ?> job) {
        if (!(job instanceof TopLevelItem)) {
            priorityCallback.addDecisionLog(0, "Job is not a TopLevelItem [" + job.getClass().getName() + "] ...");
            return null;
        }
        for (JobGroup jobGroup : this.jobGroups) {
            priorityCallback.addDecisionLog(0, "Evaluating JobGroup [" + jobGroup.getId() + "] ...");
            if (!jobGroup.getJobGroupStrategy().contains(priorityCallback, job)) continue;
            return jobGroup;
        }
        return null;
    }

    private boolean isJobInView(Job<?, ?> job, View view) {
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            return this.isJobInViewGroup(job, group);
        }
        return view.contains((TopLevelItem)job);
    }

    private boolean isJobInViewGroup(Job<?, ?> job, ViewGroup viewGroup) {
        Collection views = viewGroup.getViews();
        for (View view : views) {
            if (!this.isJobInView(job, view)) continue;
            return true;
        }
        return false;
    }

    private PriorityConfigurationCallback getPriorityForJobGroup(PriorityConfigurationCallback priorityCallback, JobGroup jobGroup, Queue.Item item) {
        int priority = jobGroup.getPriority();
        PriorityStrategy reason = null;
        if (jobGroup.isUsePriorityStrategies()) {
            priorityCallback.addDecisionLog(2, "Evaluating strategies ...");
            List<JobGroup.PriorityStrategyHolder> priorityStrategies = jobGroup.getPriorityStrategies();
            for (JobGroup.PriorityStrategyHolder priorityStrategy : priorityStrategies) {
                PriorityStrategy strategy = priorityStrategy.getPriorityStrategy();
                priorityCallback.addDecisionLog(3, "Evaluating strategy [" + strategy.getDescriptor().getDisplayName() + "] ...");
                if (!strategy.isApplicable(item)) continue;
                priorityCallback.addDecisionLog(4, "Strategy is applicable");
                int foundPriority = strategy.getPriority(item);
                if (foundPriority <= 0 || foundPriority > PrioritySorterConfiguration.get().getStrategy().getNumberOfPriorities()) continue;
                priority = foundPriority;
                reason = strategy;
                break;
            }
        }
        if (reason == null) {
            priorityCallback.addDecisionLog(2, "No applicable strategy - Using JobGroup default");
        }
        if (priority == PriorityCalculationsUtil.getUseDefaultPriorityPriority()) {
            priority = PrioritySorterConfiguration.get().getStrategy().getDefaultPriority();
        }
        return priorityCallback.setPrioritySelection(priority, jobGroup.getId(), reason);
    }

    public static PriorityConfiguration get() {
        return (PriorityConfiguration)((Object)GlobalConfiguration.all().get(PriorityConfiguration.class));
    }
}

