/*
 * Decompiled with CFR 0.152.
 */
package jenkins.advancedqueue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Queue;
import java.util.ArrayList;
import java.util.List;
import jenkins.advancedqueue.jobinclusion.JobInclusionStrategy;
import jenkins.advancedqueue.jobinclusion.strategy.ViewBasedJobInclusionStrategy;
import jenkins.advancedqueue.priority.PriorityStrategy;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JobGroup {
    private int id = 0;
    private int priority = 2;
    @Deprecated
    private String view = null;
    private JobInclusionStrategy jobGroupStrategy = null;
    private String description = "";
    private boolean runExclusive = false;
    @Deprecated
    private boolean useJobFilter = false;
    @Deprecated
    private String jobPattern = ".*";
    private boolean usePriorityStrategies;
    private List<PriorityStrategyHolder> priorityStrategies = new ArrayList<PriorityStrategyHolder>();

    @DataBoundConstructor
    public JobGroup() {
    }

    public int getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setId(int id) {
        this.id = id;
    }

    @NonNull
    public String getDescription() {
        return Util.fixNull((String)this.description);
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    @Deprecated
    @CheckForNull
    public String getView() {
        JobInclusionStrategy jobInclusionStrategy = this.jobGroupStrategy;
        if (jobInclusionStrategy instanceof ViewBasedJobInclusionStrategy) {
            ViewBasedJobInclusionStrategy strategy = (ViewBasedJobInclusionStrategy)jobInclusionStrategy;
            return strategy.getViewName();
        }
        return null;
    }

    @DataBoundSetter
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public JobInclusionStrategy getJobGroupStrategy() {
        if (this.jobGroupStrategy == null && this.view != null) {
            ViewBasedJobInclusionStrategy.JobPattern pattern = new ViewBasedJobInclusionStrategy.JobPattern(this.jobPattern);
            ViewBasedJobInclusionStrategy viewBasedJobInclusionStrategy = new ViewBasedJobInclusionStrategy(this.view);
            if (this.useJobFilter) {
                viewBasedJobInclusionStrategy.setJobFilter(pattern);
            }
            this.jobGroupStrategy = viewBasedJobInclusionStrategy;
        }
        return this.jobGroupStrategy;
    }

    @DataBoundSetter
    public void setJobGroupStrategy(JobInclusionStrategy jobGroupStrategy) {
        this.view = null;
        this.jobGroupStrategy = jobGroupStrategy;
    }

    public boolean isRunExclusive() {
        return this.runExclusive;
    }

    @DataBoundSetter
    public void setRunExclusive(boolean runExclusive) {
        this.runExclusive = runExclusive;
    }

    public boolean isUsePriorityStrategies() {
        return this.usePriorityStrategies;
    }

    @DataBoundSetter
    public void setUsePriorityStrategies(boolean usePriorityStrategies) {
        this.usePriorityStrategies = usePriorityStrategies;
    }

    public List<PriorityStrategyHolder> getPriorityStrategies() {
        return this.priorityStrategies;
    }

    @DataBoundSetter
    public void setPriorityStrategies(List<? extends PriorityStrategy> priorityStrategies) {
        if (priorityStrategies != null && priorityStrategies.size() > 0) {
            this.priorityStrategies = priorityStrategies.get(0) instanceof PriorityStrategyHolder ? priorityStrategies : this.convertToPriorityStrategyHolder(priorityStrategies);
        }
    }

    private List<PriorityStrategyHolder> convertToPriorityStrategyHolder(List<PriorityStrategy> priorityStrategies) {
        ArrayList<PriorityStrategyHolder> priorityHolderStrategies = new ArrayList<PriorityStrategyHolder>(priorityStrategies.size());
        for (int i = 0; i < priorityStrategies.size(); ++i) {
            priorityHolderStrategies.add(new PriorityStrategyHolder(i, priorityStrategies.get(i)));
        }
        return priorityHolderStrategies;
    }

    public static class PriorityStrategyHolder
    extends PriorityStrategy {
        private int id = 0;
        private PriorityStrategy priorityStrategy;

        public PriorityStrategyHolder() {
        }

        @DataBoundConstructor
        public PriorityStrategyHolder(int id, PriorityStrategy priorityStrategy) {
            this.id = id;
            this.priorityStrategy = priorityStrategy;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public PriorityStrategy getPriorityStrategy() {
            return this.priorityStrategy;
        }

        public void setPriorityStrategy(PriorityStrategy priorityStrategy) {
            this.priorityStrategy = priorityStrategy;
        }

        public Descriptor<PriorityStrategy> getDescriptor() {
            return Jenkins.get().getDescriptor(this.getClass());
        }

        @Override
        public boolean isApplicable(Queue.Item item) {
            return this.priorityStrategy.isApplicable(item);
        }

        @Override
        public int getPriority(Queue.Item item) {
            return this.priorityStrategy.getPriority(item);
        }

        @Override
        public void numberPrioritiesUpdates(int oldNumberOfPriorities, int newNumberOfPriorities) {
            this.priorityStrategy.numberPrioritiesUpdates(oldNumberOfPriorities, newNumberOfPriorities);
        }

        @Extension
        @Symbol(value={"priorityStrategy"})
        public static class PriorityStrategyHolderDescriptor
        extends Descriptor<PriorityStrategy> {
        }
    }
}

