/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.junitattachments.AttachmentPublisher;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import io.atlassian.util.concurrent.Promise;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraIssueTrigger;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JobConfigMapping;
import org.jenkinsci.plugins.JiraTestResultReporter.TestToIssueMapping;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;

public class JiraUtils {
    private static final Logger LOGGER = Logger.getLogger("JiraIssuePlugin.log");

    public static String getIssueURL(String serverURL, String issueKey) {
        return serverURL + (serverURL.charAt(serverURL.length() - 1) == '/' ? "" : "/") + "browse/" + issueKey;
    }

    public static void log(String message) {
        LOGGER.log(Level.INFO, message);
    }

    public static void logError(String message, Exception e) {
        LOGGER.log(Level.SEVERE, message, e);
    }

    public static void logError(String message) {
        LOGGER.log(Level.SEVERE, message);
    }

    public static void logWarning(String message) {
        LOGGER.log(Level.WARNING, message);
    }

    public static void logWarning(String message, Exception e) {
        LOGGER.log(Level.WARNING, message, e);
    }

    public static JiraTestDataPublisher.JiraTestDataPublisherDescriptor getJiraDescriptor() {
        return (JiraTestDataPublisher.JiraTestDataPublisherDescriptor)Jenkins.get().getDescriptor(JiraTestDataPublisher.class);
    }

    public static String getErrorMessage(RestClientException e, String newLine) {
        StringBuilder errorMessages = new StringBuilder();
        for (ErrorCollection errorCollection : e.getErrorCollections()) {
            if (errorMessages.length() != 0) {
                errorMessages.append(newLine);
            }
            errorMessages.append("Error ").append(errorCollection.getStatus());
            for (String string : errorCollection.getErrorMessages()) {
                errorMessages.append(newLine).append(string);
            }
            for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
                errorMessages.append(newLine).append((String)entry.getValue());
            }
        }
        return errorMessages.toString();
    }

    public static String createIssue(Job<?, ?> job, EnvVars envVars, CaseResult test) throws RestClientException {
        return JiraUtils.createIssue(job, job, envVars, test, JiraIssueTrigger.JOB, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cleanJobCacheFile(List<CaseResult> testCaseResults, Job<?, ?> testJob) {
        List testNames = testCaseResults.stream().filter(CaseResult::isFailed).map(TestObject::getId).collect(Collectors.toList());
        HashMap<String, String> keysToCheck = new HashMap<String, String>();
        ArrayList<String> jiraIds = new ArrayList<String>();
        for (String test : testNames) {
            if (TestToIssueMapping.getInstance().getTestIssueKey(testJob, test) == null) continue;
            String jiraId = TestToIssueMapping.getInstance().getTestIssueKey(testJob, test);
            jiraIds.add(jiraId);
            keysToCheck.put(jiraId, test);
        }
        if (keysToCheck.isEmpty()) {
            return false;
        }
        SearchResult searchResult = JiraUtils.findUnresolvedJiraIssues(String.join((CharSequence)",", jiraIds));
        if (searchResult != null) {
            for (Issue issue : searchResult.getIssues()) {
                String testId;
                String testKey = issue.getKey();
                String string = testId = (String)keysToCheck.get(testKey);
                synchronized (string) {
                    TestToIssueMapping.getInstance().removeTestToIssueMapping(testJob, testId, testKey);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createIssue(Job<?, ?> job, Job<?, ?> project, EnvVars envVars, CaseResult test, JiraIssueTrigger trigger, List<String> attachments) throws RestClientException {
        String string = test.getId();
        synchronized (string) {
            if (TestToIssueMapping.getInstance().getTestIssueKey(job, test.getId()) != null) {
                return null;
            }
            IssueInput issueInput = JiraUtils.createIssueInput(project, (TestResult)test, envVars, trigger);
            SearchResult searchResult = JiraUtils.findIssues(project, (TestResult)test, envVars, issueInput);
            if (searchResult != null) {
                boolean duplicate = false;
                FieldInput fi = JiraTestDataPublisher.JiraTestDataPublisherDescriptor.templates.get(0).getFieldInput((TestResult)test, envVars);
                String text = issueInput.getField(fi.getId()).getValue().toString();
                for (Issue issue : searchResult.getIssues()) {
                    if (!issue.getSummary().equals(text)) continue;
                    JiraUtils.log(String.format("Ignoring creating issue '%s' as it would be a duplicate. (from Jira server)", text));
                    duplicate = true;
                    TestToIssueMapping.getInstance().addTestToIssueMapping(job, test.getId(), issue.getKey());
                }
                if (duplicate) {
                    return null;
                }
            }
            String issueKey = JiraUtils.createIssueInput(issueInput, test, attachments);
            TestToIssueMapping.getInstance().addTestToIssueMapping(job, test.getId(), issueKey);
            return issueKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> searchIssueKeys(Job<?, ?> job, EnvVars envVars, CaseResult test) throws RestClientException {
        String string = test.getId();
        synchronized (string) {
            IssueInput issueInput;
            SearchResult searchResult;
            HashSet<String> issueKeys = new HashSet<String>();
            String issueKey = TestToIssueMapping.getInstance().getTestIssueKey(job, test.getId());
            if (StringUtils.isNotBlank((CharSequence)issueKey)) {
                issueKeys.add(issueKey);
                return issueKeys;
            }
            if (!JobConfigMapping.getInstance().getManualAddIssue(job) && (searchResult = JiraUtils.findIssues(job, (TestResult)test, envVars, issueInput = JiraUtils.createIssueInput(job, (TestResult)test, envVars, JiraIssueTrigger.JOB))) != null) {
                for (Issue issue : searchResult.getIssues()) {
                    issueKeys.add(issue.getKey());
                }
            }
            return issueKeys;
        }
    }

    private static IssueInput createIssueInput(Job<?, ?> project, TestResult test, EnvVars envVars, JiraIssueTrigger trigger) {
        IssueInputBuilder newIssueBuilder = new IssueInputBuilder(JobConfigMapping.getInstance().getProjectKey(project), JobConfigMapping.getInstance().getIssueType(project));
        for (AbstractFields f : JiraTestDataPublisher.JiraTestDataPublisherDescriptor.templates) {
            newIssueBuilder.setFieldInput(f.getFieldInput(test, envVars));
        }
        if (trigger.equals((Object)JiraIssueTrigger.JOB)) {
            for (AbstractFields f : JobConfigMapping.getInstance().getConfig(project)) {
                newIssueBuilder.setFieldInput(f.getFieldInput(test, envVars));
            }
        }
        return newIssueBuilder.build();
    }

    private static String createIssueInput(IssueInput issueInput, CaseResult test, List<String> attachments) {
        IssueRestClient issueClient = JiraUtils.getJiraDescriptor().getRestClient().getIssueClient();
        Promise issuePromise = issueClient.createIssue(issueInput);
        String key = ((BasicIssue)issuePromise.claim()).getKey();
        Issue issue = (Issue)issueClient.getIssue(key).claim();
        URI attachmentsUri = issue.getAttachmentsUri();
        if (StringUtils.isNotBlank((CharSequence)test.getStderr())) {
            issueClient.addAttachment(attachmentsUri, (InputStream)new ByteArrayInputStream(test.getStderr().getBytes(StandardCharsets.UTF_8)), "stderr.out").claim();
        }
        if (StringUtils.isNotBlank((CharSequence)test.getStdout())) {
            issueClient.addAttachment(attachmentsUri, (InputStream)new ByteArrayInputStream(test.getStdout().getBytes(StandardCharsets.UTF_8)), "stdout.out").claim();
        }
        if (StringUtils.isNotBlank((CharSequence)test.getErrorStackTrace())) {
            issueClient.addAttachment(attachmentsUri, (InputStream)new ByteArrayInputStream(test.getErrorStackTrace().getBytes(StandardCharsets.UTF_8)), "stacktrace.out").claim();
        }
        if (StringUtils.isNotBlank((CharSequence)test.getErrorDetails())) {
            issueClient.addAttachment(attachmentsUri, (InputStream)new ByteArrayInputStream(test.getErrorDetails().getBytes(StandardCharsets.UTF_8)), "details.out").claim();
        }
        if (!attachments.isEmpty()) {
            FilePath attachmentStorage = AttachmentPublisher.getAttachmentPath((Run)test.getRun());
            try {
                if (attachmentStorage.exists()) {
                    FilePath attachmentPath = AttachmentPublisher.getAttachmentPath((FilePath)attachmentStorage, (String)test.getClassName(), (String)test.getName());
                    for (FilePath file : attachmentPath.list()) {
                        if (!attachments.contains(file.getName())) continue;
                        issueClient.addAttachment(attachmentsUri, file.read(), file.getName()).claim();
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                JiraUtils.log(String.format("Unable to access attachment storage for %s:%s", test.getName(), test.getRun().getId()));
            }
        }
        return key;
    }

    public static SearchResult findIssues(Job<?, ?> project, TestResult test, EnvVars envVars, IssueInput issueInput) throws RestClientException {
        String projectKey = JobConfigMapping.getInstance().getProjectKey(project);
        FieldInput fi = JiraTestDataPublisher.JiraTestDataPublisherDescriptor.templates.get(0).getFieldInput(test, envVars);
        String jql = String.format("resolution = \"unresolved\" and project = \"%s\" and text ~ \"%s\"", projectKey, JiraUtils.escapeJQL(issueInput.getField(fi.getId()).getValue().toString()));
        return JiraUtils.getSearchResult(jql);
    }

    private static SearchResult findUnresolvedJiraIssues(String keys) throws RestClientException {
        String jql = String.format("key in (%s) and resolution != \"unresolved\" ", keys);
        return JiraUtils.getSearchResult(jql);
    }

    private static SearchResult getSearchResult(String jql) {
        HashSet<String> fields = new HashSet<String>();
        fields.add("issueKey");
        fields.add("summary");
        fields.add("issuetype");
        fields.add("created");
        fields.add("updated");
        fields.add("project");
        fields.add("status");
        JiraUtils.log(jql);
        Promise searchJqlPromise = JiraUtils.getJiraDescriptor().getRestClient().getSearchClient().searchJql(jql, Integer.valueOf(50), null, fields);
        return (SearchResult)searchJqlPromise.claim();
    }

    static String escapeJQL(String jql) {
        String result = jql.replace("'", "\\'").replace(" - ", "*").replace("\"", "\\\"").replace("\\+", "\\\\+").replace("&", "\\\\&").replace("\\|", "\\\\|").replace("~", "\\\\~").replace("\\*", "\\\\*").replace("?", "\\\\?");
        if (result.contains("[")) {
            result = result.substring(0, result.lastIndexOf("["));
        }
        return result;
    }
}

