/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.config;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.UserRestClient;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.tasks.test.TestResult;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UserFields
extends AbstractFields {
    private String fieldKey;
    private String value;
    private transient User user;

    @DataBoundConstructor
    public UserFields(String fieldKey, String value) {
        this.fieldKey = fieldKey;
        this.value = value;
        this.user = (User)JiraUtils.getJiraDescriptor().getRestClient().getUserClient().getUser(value).claim();
    }

    @Override
    public FieldInput getFieldInput(TestResult test, EnvVars envVars) {
        return new FieldInput(this.fieldKey, (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)this.user.getName()));
    }

    @Override
    public Object readResolve() {
        this.user = (User)JiraUtils.getJiraDescriptor().getRestClient().getUserClient().getUser(this.value).claim();
        return this;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getValue() {
        return this.value;
    }

    @Symbol(value={"jiraUserField"})
    @Extension
    public static class UserFieldsDescriptor
    extends Descriptor<AbstractFields> {
        public String getDisplayName() {
            return "User Field";
        }

        public ListBoxModel doFillFieldKeyItems(@QueryParameter @RelativePath(value="..") String projectKey, @QueryParameter @RelativePath(value="..") String issueType) {
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            try {
                return jiraDescriptor.getCacheEntry(projectKey, issueType).getUserFieldBox();
            }
            catch (NullPointerException e) {
                return new ListBoxModel();
            }
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            if (value.equals("")) {
                return FormValidation.error((String)"You need to specify a user");
            }
            UserRestClient userRestClient = JiraUtils.getJiraDescriptor().getRestClient().getUserClient();
            try {
                User user = (User)userRestClient.getUser(value).claim();
                return FormValidation.ok();
            }
            catch (RestClientException e) {
                return FormValidation.error((String)JiraUtils.getErrorMessage(e, "\n"));
            }
        }
    }
}

