/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.Objects;

public class SearchResult {
    private int startIndex;
    private int total;
    private int maxResults;
    private String nextPageToken;
    private final Iterable<Issue> issues;
    private final boolean isCloudResult;

    public SearchResult(int startIndex, int maxResults, int total, Iterable<Issue> issues) {
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.total = total;
        this.issues = issues;
        this.isCloudResult = false;
    }

    public SearchResult(Iterable<Issue> issues, String nextPageToken) {
        this.issues = issues;
        this.nextPageToken = nextPageToken;
        this.isCloudResult = true;
    }

    public int getStartIndex() {
        if (this.isCloudResult) {
            throw new UnsupportedOperationException("Start index is not available in the Cloud version of the new Enhanced Search API response. Use `nextPageToken` to fetch the next page. If there are no more pages, `nextPageToken` will be null.");
        }
        return this.startIndex;
    }

    public int getMaxResults() {
        if (this.isCloudResult) {
            throw new UnsupportedOperationException("MaxResults is not available in the Cloud version of the new Enhanced Search API response.");
        }
        return this.maxResults;
    }

    public int getTotal() {
        if (this.isCloudResult) {
            throw new UnsupportedOperationException("Total is not available in the Cloud version of the new Search API response. Please use `SearchRestClient.totalCount` instead to fetch the estimated count of the issues for a given JQL.");
        }
        return this.total;
    }

    public Iterable<Issue> getIssues() {
        return this.issues;
    }

    public String getNextPageToken() {
        if (!this.isCloudResult) {
            throw new UnsupportedOperationException("NextPageToken is not available in the DC version of the new Enhanced Search API response. Use `getStartIndex()` and `getMaxResults()` to fetch the next page.");
        }
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return this.startIndex == that.startIndex && this.total == that.total && this.maxResults == that.maxResults && Objects.equals(this.nextPageToken, that.nextPageToken) && Objects.equals(this.issues, that.issues);
    }

    public int hashCode() {
        return Objects.hash(this.startIndex, this.total, this.maxResults, this.nextPageToken, this.issues);
    }

    public String toString() {
        return "SearchResult{startIndex=" + this.startIndex + ", total=" + this.total + ", maxResults=" + this.maxResults + ", nextPageToken='" + this.nextPageToken + "', issues=" + this.issues + "}";
    }
}

