/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.config;

import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.tasks.test.TestResult;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.VariableExpander;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.jenkinsci.plugins.JiraTestResultReporter.config.Entry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StringArrayFields
extends AbstractFields {
    public static final long serialVersionUID = -8871121603596592222L;
    private String fieldKey;
    private List<Entry> values;

    @DataBoundConstructor
    public StringArrayFields(String fieldKey, List<Entry> values) {
        this.fieldKey = fieldKey;
        this.values = values;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public List<Entry> getValues() {
        return this.values;
    }

    public String toString() {
        return this.getClass().getName() + " #" + this.fieldKey + " : " + this.values.toString() + "#";
    }

    @Override
    public FieldInput getFieldInput(TestResult test, EnvVars envVars) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Entry v : this.values) {
            stringList.add(VariableExpander.expandVariables(test, envVars, v.getValue()));
        }
        FieldInput fieldInput = new FieldInput(this.fieldKey, stringList);
        return fieldInput;
    }

    @Override
    public Object readResolve() {
        return this;
    }

    @Symbol(value={"jiraStringArrayField"})
    @Extension
    public static class StringArrayFieldsDescriptor
    extends Descriptor<AbstractFields> {
        public String getDisplayName() {
            return "String Array Field";
        }

        public ListBoxModel doFillFieldKeyItems(@QueryParameter @RelativePath(value="..") String projectKey, @QueryParameter @RelativePath(value="..") String issueType) {
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            try {
                return jiraDescriptor.getCacheEntry(projectKey, issueType).getStringArrayFieldBox();
            }
            catch (NullPointerException e) {
                return new ListBoxModel();
            }
        }
    }
}

