/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.config;

import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.tasks.test.TestResult;
import hudson.util.ListBoxModel;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.VariableExpander;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StringFields
extends AbstractFields {
    public static final long serialVersionUID = 4298649925601364399L;
    private static final ListBoxModel DEFAULT_MODEL = new ListBoxModel();
    private String fieldKey;
    private String value;

    @DataBoundConstructor
    public StringFields(String fieldKey, String value) {
        this.fieldKey = fieldKey;
        this.value = value;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + " #" + this.fieldKey + " : " + this.value + "#";
    }

    @Override
    public FieldInput getFieldInput(TestResult test, EnvVars envVars) {
        FieldInput fieldInput = new FieldInput(this.fieldKey, (Object)VariableExpander.expandVariables(test, envVars, this.value));
        return fieldInput;
    }

    @Override
    public Object readResolve() {
        return this;
    }

    static {
        DEFAULT_MODEL.add((Object)new ListBoxModel.Option("Summary", "summary", false));
        DEFAULT_MODEL.add((Object)new ListBoxModel.Option("Description", "description", false));
    }

    @Symbol(value={"jiraStringField"})
    @Extension
    public static class StringFieldsDescriptor
    extends Descriptor<AbstractFields> {
        public String getDisplayName() {
            return "String Field";
        }

        public ListBoxModel doFillFieldKeyItems(@QueryParameter @RelativePath(value="..") String projectKey, @QueryParameter @RelativePath(value="..") String issueType) {
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            if (projectKey.equals("") || issueType.equals("")) {
                return DEFAULT_MODEL;
            }
            try {
                return jiraDescriptor.getCacheEntry(projectKey, issueType).getStringFieldBox();
            }
            catch (NullPointerException e) {
                return DEFAULT_MODEL;
            }
        }
    }
}

