/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.JiraTestResultReporter.config;

import com.atlassian.jira.rest.client.api.IdentifiableEntity;
import com.atlassian.jira.rest.client.api.NamedEntity;
import com.atlassian.jira.rest.client.api.domain.CustomFieldOption;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.tasks.test.TestResult;
import hudson.util.ListBoxModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraTestDataPublisher;
import org.jenkinsci.plugins.JiraTestResultReporter.JiraUtils;
import org.jenkinsci.plugins.JiraTestResultReporter.config.AbstractFields;
import org.jenkinsci.plugins.JiraTestResultReporter.config.Entry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SelectableArrayFields
extends AbstractFields {
    public static final long serialVersionUID = 312389869891081321L;
    private String fieldKey;
    private List<Entry> values;
    private transient FieldInput fieldInput;

    @DataBoundConstructor
    public SelectableArrayFields(String fieldKey, List<Entry> values) {
        this.fieldKey = fieldKey;
        this.values = values;
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        for (Entry v : values) {
            valueList.add(ComplexIssueInputFieldValue.with((String)"id", (Object)v.getValue()));
        }
        this.fieldInput = new FieldInput(fieldKey, valueList);
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public List<Entry> getValues() {
        return this.values;
    }

    @Override
    public Object readResolve() {
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        for (Entry v : this.values) {
            valueList.add(ComplexIssueInputFieldValue.with((String)"id", (Object)v.getValue()));
        }
        this.fieldInput = new FieldInput(this.fieldKey, valueList);
        return this;
    }

    public String toString() {
        return this.getClass().getName() + " #" + this.fieldKey + " : " + this.values.toString() + "#";
    }

    @Override
    public FieldInput getFieldInput(TestResult test, EnvVars envVars) {
        return this.fieldInput;
    }

    @Symbol(value={"jiraSelectableArrayField"})
    @Extension
    public static class SelectableArrayFieldsDescriptor
    extends Descriptor<AbstractFields> {
        public String getDisplayName() {
            return "Selectable Array Fields";
        }

        public ListBoxModel doFillFieldKeyItems(@QueryParameter @RelativePath(value="..") String projectKey, @QueryParameter @RelativePath(value="..") String issueType) {
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            try {
                return jiraDescriptor.getCacheEntry(projectKey, issueType).getSelectableArrayFieldBox();
            }
            catch (NullPointerException e) {
                return new ListBoxModel();
            }
        }

        public ListBoxModel doFillValueItems(@QueryParameter @RelativePath(value="../..") String projectKey, @QueryParameter @RelativePath(value="../..") String issueType, @QueryParameter @RelativePath(value="..") String fieldKey) {
            ListBoxModel listBox = new ListBoxModel();
            JiraTestDataPublisher.JiraTestDataPublisherDescriptor jiraDescriptor = JiraUtils.getJiraDescriptor();
            try {
                Iterable values = jiraDescriptor.getCacheEntry(projectKey, issueType).getFieldInfoMap().get(fieldKey).getAllowedValues();
                if (values != null) {
                    for (Object o : values) {
                        if (o instanceof CustomFieldOption) {
                            CustomFieldOption option = (CustomFieldOption)o;
                            listBox.add(option.getValue(), option.getId().toString());
                            continue;
                        }
                        if (o instanceof IdentifiableEntity && o instanceof NamedEntity) {
                            listBox.add(((NamedEntity)o).getName(), ((Long)((IdentifiableEntity)o).getId()).toString());
                            continue;
                        }
                        if (!(o instanceof NamedEntity)) continue;
                        try {
                            Method m = o.getClass().getMethod("getId", new Class[0]);
                            Long id = (Long)m.invoke(o, new Object[0]);
                            if (id == null) continue;
                            listBox.add(((NamedEntity)o).getName(), ((Object)id).toString());
                        }
                        catch (Exception exception) {}
                    }
                }
                return listBox;
            }
            catch (NullPointerException e) {
                return listBox;
            }
        }
    }
}

